/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.messaging.jms;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.entity.messaging.Queue;
import org.apache.brooklyn.entity.messaging.Topic;
import org.apache.brooklyn.entity.messaging.jms.JMSBroker;
import org.apache.brooklyn.entity.messaging.jms.JMSDestination;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JMSBrokerImpl<Q extends JMSDestination & Queue, T extends JMSDestination & Topic>
extends SoftwareProcessImpl
implements JMSBroker<Q, T> {
    private static final Logger log = LoggerFactory.getLogger(JMSBroker.class);
    Collection<String> queueNames;
    Collection<String> topicNames;
    Map<String, Q> queues = Maps.newLinkedHashMap();
    Map<String, T> topics = Maps.newLinkedHashMap();

    public JMSBrokerImpl configure(Map properties) {
        if (this.queueNames == null) {
            this.queueNames = Lists.newArrayList();
        }
        if (JavaGroovyEquivalents.groovyTruth(properties.get("queue"))) {
            this.queueNames.add((String)properties.remove("queue"));
        }
        if (JavaGroovyEquivalents.groovyTruth(properties.get("queues"))) {
            this.queueNames.addAll((Collection)properties.remove("queues"));
        }
        if (this.topicNames == null) {
            this.topicNames = Lists.newArrayList();
        }
        if (JavaGroovyEquivalents.groovyTruth(properties.get("topic"))) {
            this.topicNames.add((String)properties.remove("topic"));
        }
        if (JavaGroovyEquivalents.groovyTruth(properties.get("topics"))) {
            this.topicNames.addAll((Collection)properties.remove("topics"));
        }
        return (JMSBrokerImpl)super.configure(properties);
    }

    @Override
    public Collection<String> getQueueNames() {
        return this.queueNames;
    }

    @Override
    public Collection<String> getTopicNames() {
        return this.topicNames;
    }

    @Override
    public Map<String, Q> getQueues() {
        return this.queues;
    }

    @Override
    public Map<String, T> getTopics() {
        return this.topics;
    }

    protected void connectSensors() {
        super.connectSensors();
        this.setBrokerUrl();
    }

    protected void postStart() {
        super.postStart();
        Time.sleep((Duration)Duration.FIVE_SECONDS);
        for (String name : this.queueNames) {
            this.addQueue(name);
        }
        for (String name : this.topicNames) {
            this.addTopic(name);
        }
    }

    @Override
    public abstract void setBrokerUrl();

    public void preStop() {
        try {
            for (JMSDestination queue : this.queues.values()) {
                queue.destroy();
            }
        }
        catch (Exception e) {
            log.warn("Error deleting queues from broker " + this + "; continuing with stop...", (Throwable)e);
        }
        try {
            for (JMSDestination topic : this.topics.values()) {
                topic.destroy();
            }
        }
        catch (Exception e) {
            log.warn("Error deleting topics from broker " + this + "; continuing with stop...", (Throwable)e);
        }
        super.preStop();
    }

    @Override
    public void addQueue(String name) {
        this.addQueue(name, (Map)MutableMap.of());
    }

    public void checkStartingOrRunning() {
        Lifecycle state = (Lifecycle)this.getAttribute(SERVICE_STATE_ACTUAL);
        if (this.getAttribute(SERVICE_STATE_ACTUAL) == Lifecycle.RUNNING) {
            return;
        }
        if (this.getAttribute(SERVICE_STATE_ACTUAL) == Lifecycle.STARTING) {
            return;
        }
        throw new IllegalStateException("Cannot run against " + this + " in state " + state);
    }

    @Override
    public void addQueue(String name, Map properties) {
        this.checkStartingOrRunning();
        properties.put("name", name);
        this.queues.put(name, this.createQueue(properties));
    }

    @Override
    public abstract Q createQueue(Map var1);

    @Override
    public void addTopic(String name) {
        this.addTopic(name, (Map)MutableMap.of());
    }

    @Override
    public void addTopic(String name, Map properties) {
        this.checkStartingOrRunning();
        properties.put("name", name);
        this.topics.put(name, this.createTopic(properties));
    }

    @Override
    public abstract T createTopic(Map var1);
}

