/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.util.core.task.CompoundTask;
import org.apache.brooklyn.util.core.task.TaskTags;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.text.Strings;

public class ParallelTask<T>
extends CompoundTask<T> {
    public ParallelTask(Object ... tasks) {
        super(tasks);
    }

    public ParallelTask(Map<String, ?> flags, Collection<?> tasks) {
        super(flags, tasks);
    }

    public ParallelTask(Collection<?> tasks) {
        super(tasks);
    }

    public ParallelTask(Map<String, ?> flags, Iterable<?> tasks) {
        super(flags, (Collection<?>)ImmutableList.copyOf(tasks));
    }

    public ParallelTask(Iterable<?> tasks) {
        super((Collection<?>)ImmutableList.copyOf(tasks));
    }

    @Override
    protected List<T> runJobs() throws InterruptedException, ExecutionException {
        this.setBlockingDetails("Executing " + (this.children.size() == 1 ? "1 child task" : this.children.size() + " children tasks in parallel"));
        for (Task task : this.children) {
            this.submitIfNecessary((TaskAdaptable<?>)task);
        }
        ArrayList result = Lists.newArrayList();
        ArrayList exceptions = Lists.newArrayList();
        for (Task task : this.children) {
            Object x;
            try {
                x = task.get();
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                if (!TaskTags.isInessential(task)) {
                    exceptions.add(e);
                }
                x = null;
            }
            result.add(x);
        }
        if (exceptions.isEmpty()) {
            return result;
        }
        if (result.size() == 1 && exceptions.size() == 1) {
            throw Exceptions.propagate((Throwable)((Throwable)exceptions.get(0)));
        }
        throw Exceptions.propagate((String)(exceptions.size() + " of " + result.size() + " parallel child task" + Strings.s((int)result.size()) + " failed"), (Iterable)exceptions);
    }
}

