/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.access.flush.operation.DbRowOp;
import org.apache.cayenne.access.flush.operation.DbRowOpVisitor;
import org.apache.cayenne.access.flush.operation.DeleteDbRowOp;
import org.apache.cayenne.access.flush.operation.InsertDbRowOp;
import org.apache.cayenne.access.flush.operation.UpdateDbRowOp;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.DeleteBatchQuery;
import org.apache.cayenne.query.InsertBatchQuery;
import org.apache.cayenne.query.UpdateBatchQuery;

class QueryCreatorVisitor
implements DbRowOpVisitor<Void> {
    private final List<BatchQuery> queryList;
    private final int batchSize;
    private DbRowOp lastRow = null;
    private BatchQuery lastBatch = null;

    QueryCreatorVisitor(int size) {
        this.queryList = new ArrayList<BatchQuery>(Math.min(4, size / 2));
        this.batchSize = Math.min(2, size / 3);
    }

    List<BatchQuery> getQueryList() {
        return this.queryList;
    }

    @Override
    public Void visitInsert(InsertDbRowOp dbRow) {
        InsertBatchQuery query;
        if (this.lastRow == null || !this.lastRow.isSameBatch(dbRow)) {
            query = new InsertBatchQuery(dbRow.getEntity(), this.batchSize);
            this.queryList.add(query);
            this.lastBatch = query;
        } else {
            query = (InsertBatchQuery)this.lastBatch;
        }
        query.add(dbRow.getValues().getSnapshot(), dbRow.getChangeId());
        this.lastRow = dbRow;
        return null;
    }

    @Override
    public Void visitUpdate(UpdateDbRowOp dbRow) {
        UpdateBatchQuery query;
        if (dbRow.getValues().isEmpty()) {
            return null;
        }
        if (this.lastRow == null || !this.lastRow.isSameBatch(dbRow)) {
            query = new UpdateBatchQuery(dbRow.getEntity(), dbRow.getQualifier().getQualifierAttributes(), dbRow.getValues().getUpdatedAttributes(), dbRow.getQualifier().getNullQualifierNames(), this.batchSize);
            query.setUsingOptimisticLocking(dbRow.getQualifier().isUsingOptimisticLocking());
            this.queryList.add(query);
            this.lastBatch = query;
        } else {
            query = (UpdateBatchQuery)this.lastBatch;
        }
        query.add(dbRow.getQualifier().getSnapshot(), dbRow.getValues().getSnapshot(), dbRow.getChangeId());
        this.lastRow = dbRow;
        return null;
    }

    @Override
    public Void visitDelete(DeleteDbRowOp dbRow) {
        DeleteBatchQuery query;
        if (this.lastRow == null || !this.lastRow.isSameBatch(dbRow)) {
            query = new DeleteBatchQuery(dbRow.getEntity(), dbRow.getQualifier().getQualifierAttributes(), dbRow.getQualifier().getNullQualifierNames(), this.batchSize);
            query.setUsingOptimisticLocking(dbRow.getQualifier().isUsingOptimisticLocking());
            this.queryList.add(query);
            this.lastBatch = query;
        } else {
            query = (DeleteBatchQuery)this.lastBatch;
        }
        query.add(dbRow.getQualifier().getSnapshot());
        this.lastRow = dbRow;
        return null;
    }
}

