/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLSerializable;

public class XMLEncoder {
    protected String projectVersion;
    protected String indent;
    protected PrintWriter out;
    protected boolean indentLine;
    protected int indentTimes;
    protected boolean tagOpened;
    protected boolean cdata;
    protected int currentTagLevel;
    protected int lastTagLevel;
    protected Deque<String> openTags = new LinkedList<String>();

    public XMLEncoder(PrintWriter out) {
        this(out, null, null);
    }

    public XMLEncoder(PrintWriter out, String indent) {
        this(out, indent, null);
    }

    public XMLEncoder(PrintWriter out, String indent, String projectVersion) {
        this.indent = indent;
        this.out = out;
        this.projectVersion = projectVersion;
    }

    public XMLEncoder indent(int i) {
        this.indentTimes += i;
        if (this.indentTimes < 0) {
            this.indentTimes = 0;
        }
        return this;
    }

    public XMLEncoder print(String text) {
        this.printIndent();
        this.out.print(text);
        return this;
    }

    public XMLEncoder println(String text) {
        this.printIndent();
        this.out.println(text);
        this.indentLine = true;
        return this;
    }

    public XMLEncoder println() {
        this.out.println();
        this.indentLine = true;
        return this;
    }

    private XMLEncoder printIndent() {
        if (this.indentLine) {
            this.indentLine = false;
            if (this.indentTimes > 0 && this.indent != null) {
                for (int i = 0; i < this.indentTimes; ++i) {
                    this.out.print(this.indent);
                }
            }
        }
        return this;
    }

    public XMLEncoder start(String tag) {
        if (this.tagOpened) {
            this.println(">").indent(1);
        }
        this.printIndent().print("<").print(tag);
        this.lastTagLevel = ++this.currentTagLevel;
        this.tagOpened = true;
        this.openTags.push(tag);
        return this;
    }

    public XMLEncoder end() {
        this.tagOpened = false;
        if (this.lastTagLevel == this.currentTagLevel-- && !this.cdata) {
            this.openTags.pop();
            this.println("/>");
        } else {
            if (!this.cdata) {
                this.indent(-1).printIndent();
            }
            this.cdata = false;
            this.print("</").print(this.openTags.pop()).println(">");
        }
        return this;
    }

    public XMLEncoder attribute(String name, String value) {
        return this.attribute(name, value, false);
    }

    public XMLEncoder attribute(String name, String value, boolean newLine) {
        if (Util.isEmptyString(value)) {
            return this;
        }
        if (newLine) {
            this.indent(1).println().printIndent();
        }
        this.print(" ").print(name).print("=\"").print(Util.encodeXmlAttribute(value)).print("\"");
        if (newLine) {
            this.indent(-1);
        }
        return this;
    }

    public XMLEncoder attribute(String name, boolean value) {
        if (!value) {
            return this;
        }
        return this.attribute(name, "true");
    }

    public XMLEncoder attribute(String name, int value) {
        if (value == 0) {
            return this;
        }
        return this.attribute(name, String.valueOf(value));
    }

    public XMLEncoder cdata(String data) {
        return this.cdata(data, false);
    }

    public XMLEncoder cdata(String data, boolean escape) {
        if (this.tagOpened) {
            this.print(">");
        }
        this.cdata = true;
        if (escape) {
            this.print("<![CDATA[");
        }
        this.print(data);
        if (escape) {
            this.print("]]>");
        }
        return this;
    }

    public XMLEncoder nested(XMLSerializable object, ConfigurationNodeVisitor delegate) {
        if (object == null) {
            return this;
        }
        object.encodeAsXML(this, delegate);
        return this;
    }

    public XMLEncoder nested(Collection<? extends XMLSerializable> collection, ConfigurationNodeVisitor delegate) {
        if (collection == null) {
            return this;
        }
        for (XMLSerializable xMLSerializable : collection) {
            xMLSerializable.encodeAsXML(this, delegate);
        }
        return this;
    }

    public XMLEncoder nested(Map<?, ? extends XMLSerializable> map, ConfigurationNodeVisitor delegate) {
        if (map == null) {
            return this;
        }
        for (XMLSerializable xMLSerializable : map.values()) {
            xMLSerializable.encodeAsXML(this, delegate);
        }
        return this;
    }

    public XMLEncoder property(String name, String value) {
        if (Util.isEmptyString(value)) {
            return this;
        }
        this.start("property").attribute("name", name).attribute("value", value).end();
        this.indentLine = true;
        return this;
    }

    public XMLEncoder property(String name, boolean b) {
        if (!b) {
            return this;
        }
        return this.property(name, "true");
    }

    public XMLEncoder property(String name, int i) {
        if (i == 0) {
            return this;
        }
        return this.property(name, String.valueOf(i));
    }

    public XMLEncoder simpleTag(String tag, String value) {
        if (!Util.isEmptyString(value)) {
            this.start(tag).cdata(value).end();
        }
        return this;
    }

    public XMLEncoder projectVersion() {
        return this.attribute("project-version", this.projectVersion, true);
    }
}

