/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.ejbql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.translator.ejbql.EJBQLTableId;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslatorFactory;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.ejbql.EJBQLCompiledExpression;
import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.EntityResultSegment;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.ScalarResultSegment;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.util.CayenneMapEntry;

public class EJBQLTranslationContext {
    private EJBQLCompiledExpression compiledExpression;
    protected Map<String, Object> namedParameters;
    protected Map<Integer, Object> positionalParameters;
    private EJBQLTranslatorFactory translatorFactory;
    private QuotingStrategy quotingStrategy;
    private EntityResolver entityResolver;
    private List<Object> resultSetMetadata;
    private Map<String, String> tableAliases;
    private Map<String, Object> boundParameters;
    private Map<String, Object> attributes;
    private Map<String, String> idAliases;
    private int resultDescriptorPosition;
    private boolean usingAliases;
    private boolean caseInsensitive;
    private List<StringBuilder> bufferStack;
    private List<StringBuilder> bufferChain;
    private StringBuilder stackTop;
    private int subselectCount;
    private QueryMetadata queryMetadata;
    private boolean appendingResultColumns;

    public EJBQLTranslationContext(EntityResolver entityResolver, EJBQLQuery query, EJBQLCompiledExpression compiledExpression, EJBQLTranslatorFactory translatorFactory, QuotingStrategy quotingStrategy) {
        this.entityResolver = entityResolver;
        this.compiledExpression = compiledExpression;
        this.resultSetMetadata = query.getMetaData(entityResolver).getResultSetMapping();
        this.namedParameters = query.getNamedParameters();
        this.positionalParameters = query.getPositionalParameters();
        this.translatorFactory = translatorFactory;
        this.usingAliases = true;
        this.caseInsensitive = false;
        this.queryMetadata = query.getMetaData(entityResolver);
        this.quotingStrategy = quotingStrategy;
        this.bufferStack = new ArrayList<StringBuilder>();
        this.bufferChain = new ArrayList<StringBuilder>();
        this.stackTop = new StringBuilder();
        this.bufferChain.add(this.stackTop);
        this.bufferStack.add(this.stackTop);
    }

    public SQLTemplate getQuery() {
        StringBuilder main = this.bufferChain.get(0);
        for (int i = 1; i < this.bufferChain.size(); ++i) {
            main.append((CharSequence)this.bufferChain.get(i));
        }
        String sql = main.length() > 0 ? main.toString() : null;
        SQLTemplate query = new SQLTemplate(this.compiledExpression.getRootDescriptor().getObjectClass(), sql);
        query.setParams(this.boundParameters);
        return query;
    }

    public QueryMetadata getMetadata() {
        return this.queryMetadata;
    }

    private String resolveId(String id) {
        if (this.idAliases == null) {
            return id;
        }
        String resolvedAlias = this.idAliases.get(id);
        if (resolvedAlias != null) {
            return resolvedAlias;
        }
        return id;
    }

    EJBQLTranslatorFactory getTranslatorFactory() {
        return this.translatorFactory;
    }

    EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public ClassDescriptor getEntityDescriptor(String id) {
        return this.compiledExpression.getEntityDescriptor(this.resolveId(id));
    }

    List<DbRelationship> getIncomingRelationships(EJBQLTableId id) {
        List<DbRelationship> incoming = this.compiledExpression.getIncomingRelationships(this.resolveId(id.getEntityId()));
        if (id.getDbPath() != null) {
            DbEntity entity;
            if (incoming == null || incoming.isEmpty()) {
                entity = this.compiledExpression.getEntityDescriptor(id.getEntityId()).getEntity().getDbEntity();
            } else {
                DbRelationship last = incoming.get(incoming.size() - 1);
                entity = last.getTargetEntity();
            }
            incoming = new ArrayList<DbRelationship>(incoming);
            Iterator<CayenneMapEntry> it = entity.resolvePathComponents(id.getDbPath());
            while (it.hasNext()) {
                incoming.add((DbRelationship)it.next());
            }
        }
        return incoming;
    }

    String createIdAlias(String id) {
        if (this.idAliases == null) {
            this.idAliases = new HashMap<String, String>();
        }
        for (int i = 0; i < 1000; ++i) {
            String alias = id + "_alias" + i;
            if (this.idAliases.containsKey(alias) || this.compiledExpression.getEntityDescriptor(alias) != null) continue;
            this.idAliases.put(alias, id);
            return alias;
        }
        throw new EJBQLException("Failed to create id alias", new Object[0]);
    }

    void markCurrentPosition(String marker) {
        StringBuilder buffer = this.findOrCreateMarkedBuffer(marker);
        this.bufferChain.add(buffer);
        StringBuilder tailBuffer = new StringBuilder();
        this.bufferChain.add(tailBuffer);
        this.bufferStack.set(0, tailBuffer);
        this.stackTop = this.bufferStack.get(this.bufferStack.size() - 1);
    }

    public void pushMarker(String marker, boolean reset) {
        this.stackTop = this.findOrCreateMarkedBuffer(marker);
        if (reset) {
            this.stackTop.delete(0, this.stackTop.length());
        }
        this.bufferStack.add(this.stackTop);
    }

    void popMarker() {
        int lastIndex = this.bufferStack.size() - 1;
        this.bufferStack.remove(lastIndex);
        this.stackTop = this.bufferStack.get(lastIndex - 1);
    }

    StringBuilder findOrCreateMarkedBuffer(String marker) {
        StringBuilder buffer = (StringBuilder)this.getAttribute(marker);
        if (buffer == null) {
            buffer = new StringBuilder();
            this.setAttribute(marker, buffer);
        }
        return buffer;
    }

    Object getAttribute(String name) {
        return this.attributes != null ? this.attributes.get(name) : null;
    }

    void setAttribute(String var, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(var, value);
    }

    public EJBQLTranslationContext append(String chunk) {
        this.stackTop.append(chunk);
        return this;
    }

    public EJBQLTranslationContext append(char chunk) {
        this.stackTop.append(chunk);
        return this;
    }

    EJBQLTranslationContext trim(int n) {
        int len = this.stackTop.length();
        if (len >= n) {
            this.stackTop.delete(len - n, len);
        }
        return this;
    }

    EJBQLCompiledExpression getCompiledExpression() {
        return this.compiledExpression;
    }

    String bindPositionalParameter(int position) {
        return this.bindParameter(this.positionalParameters.get(position));
    }

    List<String> bindPositionalParameterFlatteningCollection(int position) {
        return this.bindParameters(this.positionalParameters.get(position));
    }

    String bindNamedParameter(String name) {
        return this.bindParameter(this.namedParameters.get(name));
    }

    List<String> bindNamedParameterFlatteningCollection(String name) {
        return this.bindParameters(this.namedParameters.get(name));
    }

    List<String> bindParameters(Object value) {
        if (Collection.class.isAssignableFrom(value.getClass())) {
            Iterator parameterValueIterator = ((Collection)value).iterator();
            ArrayList<String> result = new ArrayList<String>();
            while (parameterValueIterator.hasNext()) {
                result.add(this.bindParameter(parameterValueIterator.next()));
            }
            return result;
        }
        return Collections.singletonList(this.bindParameter(value));
    }

    String bindParameter(Object value) {
        return this.bindParameter(value, "id");
    }

    void rebindParameter(String boundName, Object newValue) {
        this.boundParameters.put(boundName, newValue);
    }

    String bindParameter(Object value, String prefix) {
        if (this.boundParameters == null) {
            this.boundParameters = new HashMap<String, Object>();
        }
        String var = prefix + this.boundParameters.size();
        this.boundParameters.put(var, value);
        return var;
    }

    Object getBoundParameter(String name) {
        return this.boundParameters != null ? this.boundParameters.get(name) : null;
    }

    protected String getTableAlias(String idPath, String tableName) {
        Object alias;
        if (!this.isUsingAliases()) {
            return tableName;
        }
        StringBuilder keyBuffer = new StringBuilder();
        int dot = idPath.indexOf(46);
        if (dot > 0) {
            keyBuffer.append(idPath.substring(0, dot).toLowerCase()).append(idPath.substring(dot));
        } else {
            keyBuffer.append(idPath.toLowerCase());
        }
        String key = keyBuffer.append(':').append(tableName).toString();
        if (this.tableAliases != null) {
            alias = this.tableAliases.get(key);
        } else {
            this.tableAliases = new HashMap<String, String>();
            alias = null;
        }
        if (alias == null) {
            alias = "t" + this.tableAliases.size();
            this.tableAliases.put(key, (String)alias);
        }
        return alias;
    }

    EntityResultSegment nextEntityResult() {
        if (this.resultSetMetadata == null) {
            throw new EJBQLException("No result set mapping exists for expression, can't map EntityResult", new Object[0]);
        }
        return (EntityResultSegment)this.resultSetMetadata.get(this.resultDescriptorPosition++);
    }

    String nextColumnAlias() {
        if (this.resultSetMetadata == null) {
            throw new EJBQLException("No result set mapping exists for expression, can't map column aliases", new Object[0]);
        }
        return ((ScalarResultSegment)this.resultSetMetadata.get(this.resultDescriptorPosition++)).getColumn();
    }

    public boolean isAppendingResultColumns() {
        return this.appendingResultColumns;
    }

    void setAppendingResultColumns(boolean appendingResultColumns) {
        this.appendingResultColumns = appendingResultColumns;
    }

    public boolean isUsingAliases() {
        return this.usingAliases;
    }

    public void setUsingAliases(boolean useAliases) {
        this.usingAliases = useAliases;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public QuotingStrategy getQuotingStrategy() {
        return this.quotingStrategy;
    }

    public void onSubselect() {
        ++this.subselectCount;
    }

    public String makeDistinctMarker() {
        return "DISTINCT_MARKER" + this.subselectCount;
    }

    String makeWhereMarker() {
        return "WHERE_MARKER" + this.subselectCount;
    }

    String makeEntityQualifierMarker() {
        return "ENTITY_QUALIIER" + this.subselectCount;
    }
}

