/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.lang.reflect.Field;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.SQLTreeProcessor;
import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslatorFactory;
import org.apache.cayenne.access.types.ByteType;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.access.types.JsonType;
import org.apache.cayenne.access.types.ShortType;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.oracle.OracleActionBuilder;
import org.apache.cayenne.dba.oracle.OracleByteArrayType;
import org.apache.cayenne.dba.oracle.OracleCharType;
import org.apache.cayenne.dba.oracle.OracleEJBQLTranslatorFactory;
import org.apache.cayenne.dba.oracle.OracleSQLTreeProcessor;
import org.apache.cayenne.dba.oracle.OracleUtilDateType;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.InsertBatchQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.UpdateBatchQuery;
import org.apache.cayenne.resource.ResourceLocator;

public class OracleAdapter
extends JdbcAdapter {
    public static final String ORACLE_FLOAT = "FLOAT";
    public static final String ORACLE_BLOB = "BLOB";
    public static final String ORACLE_CLOB = "CLOB";
    public static final String ORACLE_NCLOB = "NCLOB";
    public static final String TRIM_FUNCTION = "RTRIM";
    public static final String NEW_CLOB_FUNCTION = "EMPTY_CLOB()";
    public static final String NEW_BLOB_FUNCTION = "EMPTY_BLOB()";
    protected static boolean initDone;
    protected static int oracleCursorType;
    protected static boolean supportsOracleLOB;
    private List<String> SYSTEM_SCHEMAS = Arrays.asList("ANONYMOUS", "APPQOSSYS", "AUDSYS", "CTXSYS", "DBSFWUSER", "DBSNMP", "DIP", "DVF", "GGSYS", "DVSYS", "GSMADMIN_INTERNAL", "GSMCATUSER", "GSMUSER", "LBACSYS", "MDDATA", "MDSYS", "OJVMSYS", "OLAPSYS", "ORACLE_OCM", "ORDDATA", "ORDPLUGINS", "ORDSYS", "OUTLN", "REMOTE_SCHEDULER_AGENT", "SYSTEM", "WMSYS", "SI_INFORMTN_SCHEMA", "SYS", "SYSBACKUP", "SYSDG", "SYSKM", "SYSRAC", "SYS$UMF", "XDB", "XS$NULL");

    protected static void initDriverInformation() {
        initDone = true;
        try {
            Class<?> oraTypes = Class.forName("oracle.jdbc.driver.OracleTypes");
            Field cursorField = oraTypes.getField("CURSOR");
            oracleCursorType = cursorField.getInt(null);
            supportsOracleLOB = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean isSupportsOracleLOB() {
        return supportsOracleLOB;
    }

    static boolean updatesLOBColumns(BatchQuery query) {
        boolean isInsert = query instanceof InsertBatchQuery;
        boolean isUpdate = query instanceof UpdateBatchQuery;
        if (!isInsert && !isUpdate) {
            return false;
        }
        List<DbAttribute> updatedAttributes = isInsert ? query.getDbAttributes() : ((UpdateBatchQuery)query).getUpdatedAttributes();
        for (DbAttribute attr : updatedAttributes) {
            int type = attr.getType();
            if (type != 2005 && type != 2004) continue;
            return true;
        }
        return false;
    }

    public static int getOracleCursorType() {
        if (oracleCursorType == Integer.MAX_VALUE) {
            throw new CayenneRuntimeException("No information exists about oracle types. Check that Oracle JDBC driver is available to the application.", new Object[0]);
        }
        return oracleCursorType;
    }

    public OracleAdapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.type_factories") List<ExtendedTypeFactory> extendedTypeFactories, @Inject(value="cayenne.resource_locator") ResourceLocator resourceLocator, @Inject ValueObjectTypeRegistry valueObjectTypeRegistry) {
        super(runtimeProperties, defaultExtendedTypes, userExtendedTypes, extendedTypeFactories, resourceLocator, valueObjectTypeRegistry);
        this.setSupportsBatchUpdates(true);
    }

    @Override
    public SQLTreeProcessor getSqlTreeProcessor() {
        return new OracleSQLTreeProcessor();
    }

    @Override
    protected EJBQLTranslatorFactory createEJBQLTranslatorFactory() {
        return new OracleEJBQLTranslatorFactory();
    }

    @Override
    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        OracleCharType charType = new OracleCharType();
        map.registerType(charType);
        map.registerType(new OracleByteArrayType());
        map.registerType(new OracleUtilDateType());
        map.registerType(new ShortType(true));
        map.registerType(new ByteType(true));
        map.registerType(new OracleBooleanType());
        map.registerType(new JsonType(charType, true));
    }

    @Override
    public Collection<String> dropTableStatements(DbEntity table) {
        return Collections.singleton("DROP TABLE " + this.getQuotingStrategy().quotedFullyQualifiedName(table) + " CASCADE CONSTRAINTS");
    }

    @Override
    public void bindParameter(PreparedStatement statement, ParameterBinding binding) throws SQLException, Exception {
        if (binding.getValue() == null && binding.getJdbcType() == 16) {
            ExtendedType typeProcessor = this.getExtendedTypes().getRegisteredType(Boolean.class);
            typeProcessor.setJdbcObject(statement, binding.getValue(), binding.getStatementPosition(), binding.getJdbcType(), binding.getScale());
        } else {
            super.bindParameter(statement, binding);
        }
    }

    @Override
    public DbAttribute buildAttribute(String name, String typeName, int type, int size, int scale, boolean allowNulls) {
        DbAttribute attr = super.buildAttribute(name, typeName, type, size, scale, allowNulls);
        if (type == 3 && scale <= 0) {
            if (size <= 9) {
                attr.setType(4);
            } else if (size <= 19) {
                attr.setType(-5);
            }
            attr.setScale(-1);
        } else if (type == 1111) {
            if (ORACLE_FLOAT.equals(typeName)) {
                attr.setType(6);
            } else if (ORACLE_BLOB.equals(typeName)) {
                attr.setType(2004);
            } else if (ORACLE_CLOB.equals(typeName)) {
                attr.setType(2005);
            } else if (ORACLE_NCLOB.equals(typeName)) {
                attr.setType(2011);
            }
        } else if (type == 91 && "DATE".equals(typeName)) {
            attr.setType(93);
        }
        return attr;
    }

    @Override
    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new OracleActionBuilder(node));
    }

    @Override
    public List<String> getSystemSchemas() {
        return this.SYSTEM_SCHEMAS;
    }

    @Override
    public boolean typeSupportsScale(int type) {
        return type != 92 && super.typeSupportsScale(type);
    }

    static {
        oracleCursorType = Integer.MAX_VALUE;
        OracleAdapter.initDriverInformation();
    }

    final class OracleBooleanType
    implements ExtendedType<Boolean> {
        OracleBooleanType() {
        }

        @Override
        public String getClassName() {
            return Boolean.class.getName();
        }

        @Override
        public void setJdbcObject(PreparedStatement st, Boolean val, int pos, int type, int precision) throws Exception {
            if (val == null) {
                st.setNull(pos, 4);
            } else {
                boolean flag = Boolean.TRUE.equals(val);
                st.setInt(pos, flag ? 1 : 0);
            }
        }

        @Override
        public Boolean materializeObject(ResultSet rs, int index, int type) throws Exception {
            int i = rs.getInt(index);
            return rs.wasNull() ? null : (i == 0 ? Boolean.FALSE : Boolean.TRUE);
        }

        @Override
        public Boolean materializeObject(CallableStatement st, int index, int type) throws Exception {
            int i = st.getInt(index);
            return st.wasNull() ? null : (i == 0 ? Boolean.FALSE : Boolean.TRUE);
        }

        @Override
        public String toString(Boolean value) {
            if (value == null) {
                return "NULL";
            }
            return "'" + value.toString() + "'";
        }
    }
}

