/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sybase;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.cayenne.configuration.runtime.DbAdapterDetector;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.sybase.SybaseAdapter;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;

public class SybaseSniffer
implements DbAdapterDetector {
    protected AdhocObjectFactory objectFactory;

    public SybaseSniffer(@Inject AdhocObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public DbAdapter createAdapter(DatabaseMetaData md) throws SQLException {
        String driver = md.getDriverName();
        if (driver != null && driver.toLowerCase().startsWith("jtds")) {
            String url = md.getURL();
            return url != null && url.toLowerCase().startsWith("jdbc:jtds:sybase:") ? this.objectFactory.newInstance(DbAdapter.class, SybaseAdapter.class.getName()) : null;
        }
        String dbName = md.getDatabaseProductName();
        return dbName != null && dbName.toUpperCase().contains("ADAPTIVE SERVER") ? this.objectFactory.newInstance(DbAdapter.class, SybaseAdapter.class.getName()) : null;
    }
}

