/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.xml;

import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.xml.CatalogHandler;
import org.apache.cayenne.dbsync.xml.IncludeTableHandler;
import org.apache.cayenne.dbsync.xml.SchemaHandler;
import org.apache.cayenne.dbsync.xml.TableTypesHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

class ConfigHandler
extends NamespaceAwareNestedTagHandler {
    static final String OLD_CONFIG_TAG = "config";
    static final String CONFIG_TAG = "dbImport";
    private static final String CATALOG_TAG = "catalog";
    private static final String SCHEMA_TAG = "schema";
    private static final String TABLE_TYPES_TAG = "tableTypes";
    private static final String DEFAULT_PACKAGE_TAG = "defaultPackage";
    private static final String FORCE_DATAMAP_CATALOG_TAG = "forceDataMapCatalog";
    private static final String FORCE_DATAMAP_SCHEMA_TAG = "forceDataMapSchema";
    private static final String MEANINGFUL_PK_TABLES_TAG = "meaningfulPkTables";
    private static final String NAMING_STRATEGY_TAG = "namingStrategy";
    private static final String SKIP_PK_LOADING_TAG = "skipPrimaryKeyLoading";
    private static final String SKIP_RELATIONSHIPS_LOADING_TAG = "skipRelationshipsLoading";
    private static final String STRIP_FROM_TABLE_NAMES_TAG = "stripFromTableNames";
    private static final String USE_JAVA7_TYPES_TAG = "useJava7Types";
    private static final String INCLUDE_TABLE_TAG = "includeTable";
    private static final String EXCLUDE_TABLE_TAG = "excludeTable";
    private static final String INCLUDE_COLUMN_TAG = "includeColumn";
    private static final String EXCLUDE_COLUMN_TAG = "excludeColumn";
    private static final String INCLUDE_PROCEDURE_TAG = "includeProcedure";
    private static final String EXCLUDE_PROCEDURE_TAG = "excludeProcedure";
    private static final String TRUE = "true";
    private ReverseEngineering configuration;
    private DataChannelMetaData metaData;

    ConfigHandler(NamespaceAwareNestedTagHandler parentHandler, DataChannelMetaData metaData) {
        super(parentHandler);
        this.metaData = metaData;
        this.targetNamespace = "http://cayenne.apache.org/schema/11/dbimport";
    }

    @Override
    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) throws SAXException {
        switch (localName) {
            case "dbImport": 
            case "config": {
                this.createConfig();
                return true;
            }
        }
        return false;
    }

    @Override
    protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String qName, Attributes attributes) {
        if (namespaceURI.equals(this.targetNamespace)) {
            switch (localName) {
                case "catalog": {
                    return new CatalogHandler(this, this.configuration);
                }
                case "schema": {
                    return new SchemaHandler(this, this.configuration);
                }
                case "includeTable": {
                    return new IncludeTableHandler(this, this.configuration);
                }
                case "tableTypes": {
                    return new TableTypesHandler(this, this.configuration);
                }
            }
        }
        return super.createChildTagHandler(namespaceURI, localName, qName, attributes);
    }

    @Override
    protected boolean processCharData(String localName, String data) {
        switch (localName) {
            case "defaultPackage": {
                this.createDefaultPackage(data);
                break;
            }
            case "forceDataMapCatalog": {
                this.createForceDatamapCatalog(data);
                break;
            }
            case "forceDataMapSchema": {
                this.createForceDatamapSchema(data);
                break;
            }
            case "meaningfulPkTables": {
                this.createMeaningfulPkTables(data);
                break;
            }
            case "namingStrategy": {
                this.createNamingStrategy(data);
                break;
            }
            case "skipPrimaryKeyLoading": {
                this.createSkipPkLoading(data);
                break;
            }
            case "skipRelationshipsLoading": {
                this.createSkipRelationshipsLoading(data);
                break;
            }
            case "stripFromTableNames": {
                this.createStripFromTableNames(data);
                break;
            }
            case "useJava7Types": {
                this.createUseJava7Types(data);
                break;
            }
            case "excludeTable": {
                this.createExcludeTable(data);
                break;
            }
            case "includeColumn": {
                this.createIncludeColumn(data);
                break;
            }
            case "excludeColumn": {
                this.createExcludeColumn(data);
                break;
            }
            case "includeProcedure": {
                this.createIncludeProcedure(data);
                break;
            }
            case "excludeProcedure": {
                this.createExcludeProcedure(data);
            }
        }
        return true;
    }

    private void createExcludeProcedure(String excludeProcedure) {
        if (excludeProcedure.trim().length() == 0) {
            return;
        }
        if (this.configuration != null) {
            this.configuration.addExcludeProcedure(new ExcludeProcedure(excludeProcedure));
        }
    }

    private void createIncludeProcedure(String includeProcedure) {
        if (includeProcedure.trim().length() == 0) {
            return;
        }
        if (this.configuration != null) {
            this.configuration.addIncludeProcedure(new IncludeProcedure(includeProcedure));
        }
    }

    private void createExcludeColumn(String excludeColumn) {
        if (excludeColumn.trim().length() == 0) {
            return;
        }
        if (this.configuration != null) {
            this.configuration.addExcludeColumn(new ExcludeColumn(excludeColumn));
        }
    }

    private void createIncludeColumn(String includeColumn) {
        if (includeColumn.trim().length() == 0) {
            return;
        }
        if (this.configuration != null) {
            this.configuration.addIncludeColumn(new IncludeColumn(includeColumn));
        }
    }

    private void createExcludeTable(String excludeTable) {
        if (excludeTable.trim().length() == 0) {
            return;
        }
        if (this.configuration != null) {
            this.configuration.addExcludeTable(new ExcludeTable(excludeTable));
        }
    }

    private void createUseJava7Types(String useJava7Types) {
        if (useJava7Types.trim().length() == 0) {
            return;
        }
        if (this.configuration != null) {
            if (useJava7Types.equals(TRUE)) {
                this.configuration.setUseJava7Types(true);
            } else {
                this.configuration.setUseJava7Types(false);
            }
        }
    }

    private void createStripFromTableNames(String stripFromTableNames) {
        if (stripFromTableNames.trim().length() == 0) {
            return;
        }
        if (this.configuration != null) {
            this.configuration.setStripFromTableNames(stripFromTableNames);
        }
    }

    private void createSkipRelationshipsLoading(String skipRelationshipsLoading) {
        if (skipRelationshipsLoading.trim().length() == 0) {
            return;
        }
        if (this.configuration != null) {
            if (skipRelationshipsLoading.equals(TRUE)) {
                this.configuration.setSkipRelationshipsLoading(true);
            } else {
                this.configuration.setSkipRelationshipsLoading(false);
            }
        }
    }

    private void createSkipPkLoading(String skipPkLoading) {
        if (skipPkLoading.trim().length() == 0) {
            return;
        }
        if (this.configuration != null) {
            if (skipPkLoading.equals(TRUE)) {
                this.configuration.setSkipPrimaryKeyLoading(true);
            } else {
                this.configuration.setSkipPrimaryKeyLoading(false);
            }
        }
    }

    private void createNamingStrategy(String namingStrategy) {
        if (namingStrategy.trim().length() == 0) {
            return;
        }
        if (this.configuration != null) {
            this.configuration.setNamingStrategy(namingStrategy);
        }
    }

    private void createMeaningfulPkTables(String meaningfulPkTables) {
        if (meaningfulPkTables.trim().length() == 0) {
            return;
        }
        if (this.configuration != null) {
            this.configuration.setMeaningfulPkTables(meaningfulPkTables);
        }
    }

    private void createForceDatamapSchema(String forceDatamapSchema) {
        if (forceDatamapSchema.trim().length() == 0) {
            return;
        }
        if (this.configuration != null) {
            if (forceDatamapSchema.equals(TRUE)) {
                this.configuration.setForceDataMapSchema(true);
            } else {
                this.configuration.setForceDataMapSchema(false);
            }
        }
    }

    private void createForceDatamapCatalog(String forceDatamapCatalog) {
        if (forceDatamapCatalog.trim().length() == 0) {
            return;
        }
        if (this.configuration != null) {
            if (forceDatamapCatalog.equals(TRUE)) {
                this.configuration.setForceDataMapCatalog(true);
            } else {
                this.configuration.setForceDataMapCatalog(false);
            }
        }
    }

    private void createDefaultPackage(String defaultPackage) {
        if (defaultPackage.trim().length() == 0) {
            return;
        }
        if (this.configuration != null) {
            this.configuration.setDefaultPackage(defaultPackage);
        }
    }

    private void createConfig() {
        this.configuration = new ReverseEngineering();
        this.loaderContext.addDataMapListener(dataMap -> this.metaData.add(dataMap, this.configuration));
    }
}

