/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen.xml;

import java.nio.file.Paths;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.gen.CgenConfigList;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.gen.CgenTemplate;
import org.apache.cayenne.gen.TemplateType;
import org.apache.cayenne.gen.internal.Utils;
import org.xml.sax.Attributes;

public class CgenConfigHandler
extends NamespaceAwareNestedTagHandler {
    public static final String CONFIG_TAG = "cgen";
    private static final String NAME = "name";
    private static final String OUTPUT_DIRECTORY_TAG = "destDir";
    private static final String GENERATION_MODE_TAG = "mode";
    private static final String SUBCLASS_TEMPLATE_TAG = "template";
    private static final String SUPERCLASS_TEMPLATE_TAG = "superTemplate";
    private static final String EMBEDDABLE_TEMPLATE_TAG = "embeddableTemplate";
    private static final String EMBEDDABLE_SUPER_TEMPLATE_TAG = "embeddableSuperTemplate";
    private static final String DATAMAP_TEMPLATE_TAG = "dataMapTemplate";
    private static final String DATAMAP_SUPER_TEMPLATE_TAG = "dataMapSuperTemplate";
    private static final String OUTPUT_PATTERN_TAG = "outputPattern";
    private static final String MAKE_PAIRS_TAG = "makePairs";
    private static final String USE_PKG_PATH_TAG = "usePkgPath";
    private static final String OVERWRITE_SUBCLASSES_TAG = "overwrite";
    private static final String CREATE_PROPERTY_NAMES_TAG = "createPropertyNames";
    private static final String EXCLUDE_ENTITIES_TAG = "excludeEntities";
    private static final String EXCLUDE_EMBEDDABLES_TAG = "excludeEmbeddables";
    private static final String CREATE_PK_PROPERTIES = "createPKProperties";
    private static final String SUPER_PKG_TAG = "superPkg";
    public static final String TRUE = "true";
    private DataChannelMetaData metaData;
    private CgenConfiguration configuration;

    CgenConfigHandler(NamespaceAwareNestedTagHandler parentHandler, DataChannelMetaData metaData) {
        super(parentHandler);
        this.metaData = metaData;
        this.targetNamespace = "http://cayenne.apache.org/schema/11/cgen";
        this.configuration = new CgenConfiguration();
    }

    @Override
    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) {
        if (CONFIG_TAG.equals(localName)) {
            this.createConfig();
            return true;
        }
        return false;
    }

    @Override
    protected boolean processCharData(String localName, String data) {
        switch (localName) {
            case "name": {
                this.setName(data);
                break;
            }
            case "destDir": {
                this.createOutputDir(data);
                break;
            }
            case "mode": {
                this.createGenerationMode(data);
                break;
            }
            case "excludeEntities": {
                this.createExcludeEntities(data);
                break;
            }
            case "excludeEmbeddables": {
                this.createExcludeEmbeddables(data);
                break;
            }
            case "template": {
                this.createSubclassTemplate(data);
                break;
            }
            case "superTemplate": {
                this.createSuperclassTemplate(data);
                break;
            }
            case "embeddableTemplate": {
                this.createEmbeddableTemplate(data);
                break;
            }
            case "embeddableSuperTemplate": {
                this.createEmbeddableSuperTemplate(data);
            }
            case "dataMapTemplate": {
                this.createDataMapTemplate(data);
                break;
            }
            case "dataMapSuperTemplate": {
                this.createDataMapSuperTemplate(data);
                break;
            }
            case "outputPattern": {
                this.createOutputPattern(data);
                break;
            }
            case "makePairs": {
                this.createMakePairs(data);
                break;
            }
            case "usePkgPath": {
                this.createUsePkgPath(data);
                break;
            }
            case "overwrite": {
                this.createOverwriteSubclasses(data);
                break;
            }
            case "createPropertyNames": {
                this.createPropertyNamesTag(data);
                break;
            }
            case "createPKProperties": {
                this.createPkPropertiesTag(data);
                break;
            }
            case "superPkg": {
                this.createSuperPkg(data);
            }
        }
        return true;
    }

    private void setName(String name) {
        if (name.trim().length() == 0) {
            return;
        }
        this.configuration.setName(name);
    }

    private void createOutputDir(String path) {
        if (path.trim().length() == 0) {
            return;
        }
        this.configuration.updateOutputPath(Paths.get(path, new String[0]));
    }

    private void createGenerationMode(String mode) {
        if (mode.trim().length() == 0) {
            return;
        }
        this.configuration.setArtifactsGenerationMode(mode);
    }

    private void createExcludeEntities(String entities) {
        if (entities.trim().length() == 0) {
            return;
        }
        this.configuration.parseExcludedEntities(entities);
    }

    private void createExcludeEmbeddables(String embeddables) {
        if (embeddables.trim().length() == 0) {
            return;
        }
        this.configuration.parseExcludedEmbeddables(embeddables);
    }

    private void createSubclassTemplate(String template) {
        if (template.trim().length() == 0) {
            return;
        }
        if (TemplateType.isDefault(template)) {
            this.configuration.setTemplate(TemplateType.ENTITY_SUBCLASS.defaultTemplate());
        } else {
            this.configuration.setTemplate(new CgenTemplate(template, false, TemplateType.ENTITY_SUBCLASS));
        }
    }

    private void createSuperclassTemplate(String template) {
        if (template.trim().length() == 0) {
            return;
        }
        if (TemplateType.isDefault(template)) {
            this.configuration.setSuperTemplate(TemplateType.ENTITY_SUPERCLASS.defaultTemplate());
        } else {
            this.configuration.setSuperTemplate(new CgenTemplate(template, false, TemplateType.ENTITY_SUBCLASS));
        }
    }

    private void createEmbeddableTemplate(String template) {
        if (template.trim().length() == 0) {
            return;
        }
        if (TemplateType.isDefault(template)) {
            this.configuration.setEmbeddableTemplate(TemplateType.EMBEDDABLE_SUBCLASS.defaultTemplate());
        } else {
            this.configuration.setEmbeddableTemplate(new CgenTemplate(template, false, TemplateType.EMBEDDABLE_SUBCLASS));
        }
    }

    private void createEmbeddableSuperTemplate(String template) {
        if (template.trim().length() == 0) {
            return;
        }
        if (TemplateType.isDefault(template)) {
            this.configuration.setEmbeddableSuperTemplate(TemplateType.EMBEDDABLE_SUPERCLASS.defaultTemplate());
        } else {
            this.configuration.setEmbeddableSuperTemplate(new CgenTemplate(template, false, TemplateType.EMBEDDABLE_SUPERCLASS));
        }
    }

    private void createDataMapTemplate(String template) {
        if (template.trim().length() == 0) {
            return;
        }
        if (TemplateType.isDefault(template)) {
            this.configuration.setDataMapTemplate(TemplateType.DATAMAP_SUBCLASS.defaultTemplate());
        } else {
            this.configuration.setDataMapTemplate(new CgenTemplate(template, false, TemplateType.DATAMAP_SUBCLASS));
        }
    }

    private void createDataMapSuperTemplate(String template) {
        if (template.trim().length() == 0) {
            return;
        }
        if (TemplateType.isDefault(template)) {
            this.configuration.setDataMapSuperTemplate(TemplateType.DATAMAP_SUPERCLASS.defaultTemplate());
        } else {
            this.configuration.setDataMapSuperTemplate(new CgenTemplate(template, false, TemplateType.DATAMAP_SUPERCLASS));
        }
    }

    private void createOutputPattern(String pattern) {
        if (pattern.trim().length() == 0) {
            return;
        }
        this.configuration.setOutputPattern(pattern);
    }

    private void createMakePairs(String makePairs) {
        if (makePairs.trim().length() == 0) {
            return;
        }
        this.configuration.setMakePairs(makePairs.equals(TRUE));
    }

    private void createUsePkgPath(String data) {
        if (data.trim().length() == 0) {
            return;
        }
        this.configuration.setUsePkgPath(data.equals(TRUE));
    }

    private void createOverwriteSubclasses(String data) {
        if (data.trim().length() == 0) {
            return;
        }
        this.configuration.setOverwrite(data.equals(TRUE));
    }

    private void createPropertyNamesTag(String data) {
        if (data.trim().length() == 0) {
            return;
        }
        this.configuration.setCreatePropertyNames(data.equals(TRUE));
    }

    private void createPkPropertiesTag(String data) {
        if (data.trim().length() == 0) {
            return;
        }
        this.configuration.setCreatePKProperties(data.equals(TRUE));
    }

    private void createSuperPkg(String data) {
        if (data.trim().length() == 0) {
            return;
        }
        this.configuration.setSuperPkg(data);
    }

    private void createConfig() {
        this.loaderContext.addDataMapListener(dataMap -> {
            this.configuration.setDataMap(dataMap);
            this.configuration.setRootPath(Utils.getRootPathForDataMap(dataMap));
            this.configuration.resolveExcludedEntities();
            this.configuration.resolveExcludedEmbeddables();
            CgenConfigList configurations = this.metaData.get(dataMap, CgenConfigList.class);
            if (configurations == null) {
                configurations = new CgenConfigList();
                this.metaData.add(dataMap, configurations);
            }
            configurations.add(this.configuration);
        });
    }
}

