/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.pref;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.Preferences;
import org.apache.cayenne.pref.CayennePreference;
import org.apache.cayenne.pref.PreferenceException;
import org.apache.cayenne.reflect.PropertyUtils;

public class ComponentGeometry
extends CayennePreference {
    public static final String GEOMETRY_PREF_KEY = "geometry";
    public static final String HEIGHT_PROPERTY = "height";
    public static final String WIDTH_PROPERTY = "width";
    public static final String X_PROPERTY = "x";
    public static final String Y_PROPERTY = "y";

    public ComponentGeometry(Class<?> className, String path) {
        this.setCurrentNodeForPreference(className, path);
    }

    public Preferences getPreference() {
        if (this.getCurrentPreference() == null) {
            this.setCurrentNodeForPreference(this.getClass(), GEOMETRY_PREF_KEY);
        }
        return this.getCurrentPreference();
    }

    public void bind(final Window window, int initialWidth, int initialHeight, int maxOffset) {
        this.updateSize(window, initialWidth, initialHeight);
        this.updateLocation(window, maxOffset);
        window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ComponentGeometry.this.setWidth(window.getWidth());
                ComponentGeometry.this.setHeight(window.getHeight());
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                ComponentGeometry.this.setX(window.getX());
                ComponentGeometry.this.setY(window.getY());
            }
        });
    }

    public void bindSize(final Window window, int initialWidth, int initialHeight) {
        this.updateSize(window, initialWidth, initialHeight);
        window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ComponentGeometry.this.setWidth(window.getWidth());
                ComponentGeometry.this.setHeight(window.getHeight());
            }
        });
    }

    public void bindIntProperty(Component component, final String property, int defaultValue) {
        this.updateIntProperty(component, property, defaultValue);
        component.addPropertyChangeListener(property, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Object value = e.getNewValue();
                ComponentGeometry.this.getPreference().put(property, value != null ? value.toString() : null);
            }
        });
    }

    void updateIntProperty(Component c, String property, int defaultValue) {
        int i = this.getPreference().getInt(property, defaultValue);
        try {
            PropertyUtils.setProperty(c, property, i);
        }
        catch (Throwable th) {
            throw new PreferenceException("Error setting property: " + property, th);
        }
    }

    void updateSize(Component c, int initialWidth, int initialHeight) {
        int w = this.getWidth(initialWidth);
        int h = this.getHeight(initialHeight);
        if (w > 0 && h > 0) {
            c.setSize(w, h);
        }
    }

    void updateLocation(Component c, int maxOffset) {
        if (maxOffset != 0) {
            int xOffset = (int)(Math.random() * (double)maxOffset);
            int yOffset = (int)(Math.random() * (double)maxOffset);
            this.changeX(xOffset);
            this.changeY(yOffset);
        }
        int x = this.getX(-1);
        int y = this.getY(-1);
        if (x > 0 && y > 0) {
            c.setLocation(x, y);
        }
    }

    public void changeX(int xOffset) {
        if (xOffset != 0) {
            this.setX(this.getX(0) + xOffset);
        }
    }

    public void changeY(int yOffset) {
        if (yOffset != 0) {
            this.setY(this.getY(0) + yOffset);
        }
    }

    private void setY(Integer y) {
        this.getPreference().putInt(Y_PROPERTY, y);
    }

    private void setX(Integer x) {
        this.getPreference().putInt(X_PROPERTY, x);
    }

    private void setHeight(Integer height) {
        this.getPreference().putInt(HEIGHT_PROPERTY, height);
    }

    private void setWidth(Integer width) {
        this.getPreference().putInt(WIDTH_PROPERTY, width);
    }

    public int getWidth(int defaultValue) {
        return this.getPreference().getInt(WIDTH_PROPERTY, defaultValue);
    }

    public int getHeight(int defaultValue) {
        return this.getPreference().getInt(HEIGHT_PROPERTY, defaultValue);
    }

    public int getX(int defaultValue) {
        return this.getPreference().getInt(X_PROPERTY, defaultValue);
    }

    public int getY(int defaultValue) {
        return this.getPreference().getInt(Y_PROPERTY, defaultValue);
    }
}

