/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.sql.DataSource;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.configuration.runtime.CoreModule;
import org.apache.cayenne.configuration.runtime.CoreModuleExtender;
import org.apache.cayenne.configuration.runtime.DataSourceFactory;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.di.spi.ModuleLoader;
import org.apache.cayenne.runtime.CayenneRuntime;
import org.apache.cayenne.runtime.CayenneRuntimeModuleProvider;
import org.apache.cayenne.runtime.FixedDataSourceFactory;
import org.apache.cayenne.runtime.SyntheticNodeDataDomainProvider;

public class CayenneRuntimeBuilder {
    static final String DEFAULT_NAME = "cayenne";
    private final String name;
    private final Collection<String> configs = new LinkedHashSet<String>();
    private final List<Module> modules = new ArrayList<Module>();
    private DataSourceFactory dataSourceFactory;
    private String jdbcUrl;
    private String jdbcDriver;
    private String jdbcUser;
    private String jdbcPassword;
    private int jdbcMinConnections;
    private int jdbcMaxConnections;
    private long maxQueueWaitTime;
    private String validationQuery;
    private boolean autoLoadModules;

    protected CayenneRuntimeBuilder(String name) {
        this.name = name;
        this.autoLoadModules = true;
    }

    public CayenneRuntimeBuilder disableModulesAutoLoading() {
        this.autoLoadModules = false;
        return this;
    }

    public CayenneRuntimeBuilder dataSource(DataSource dataSource) {
        this.dataSourceFactory = new FixedDataSourceFactory(dataSource);
        return this;
    }

    public CayenneRuntimeBuilder url(String url) {
        this.jdbcUrl = url;
        return this;
    }

    public CayenneRuntimeBuilder jdbcDriver(String driver) {
        this.jdbcDriver = driver;
        return this;
    }

    public CayenneRuntimeBuilder validationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
        return this;
    }

    public CayenneRuntimeBuilder maxQueueWaitTime(long maxQueueWaitTime) {
        this.maxQueueWaitTime = maxQueueWaitTime;
        return this;
    }

    public CayenneRuntimeBuilder user(String user) {
        this.jdbcUser = user;
        return this;
    }

    public CayenneRuntimeBuilder password(String password) {
        this.jdbcPassword = password;
        return this;
    }

    public CayenneRuntimeBuilder minConnections(int minConnections) {
        this.jdbcMinConnections = minConnections;
        return this;
    }

    public CayenneRuntimeBuilder maxConnections(int maxConnections) {
        this.jdbcMaxConnections = maxConnections;
        return this;
    }

    public CayenneRuntimeBuilder addConfig(String configurationLocation) {
        this.configs.add(configurationLocation);
        return this;
    }

    public CayenneRuntimeBuilder addConfigs(String ... configurationLocations) {
        if (configurationLocations != null) {
            this.configs.addAll(Arrays.asList(configurationLocations));
        }
        return this;
    }

    public CayenneRuntimeBuilder addConfigs(Collection<String> configurationLocations) {
        this.configs.addAll(configurationLocations);
        return this;
    }

    public CayenneRuntimeBuilder addModule(Module module) {
        this.modules.add(module);
        return this;
    }

    public CayenneRuntimeBuilder addModules(Collection<Module> modules) {
        this.modules.addAll(modules);
        return this;
    }

    public CayenneRuntime build() {
        ArrayList<Module> allModules = new ArrayList<Module>();
        allModules.addAll(this.autoLoadModules ? this.autoLoadedModules() : this.defaultModules());
        allModules.addAll(this.modules);
        allModules.addAll(this.builderModules());
        return new CayenneRuntime(allModules);
    }

    private Collection<? extends Module> autoLoadedModules() {
        return new ModuleLoader().load(CayenneRuntimeModuleProvider.class);
    }

    private Collection<? extends Module> defaultModules() {
        return Collections.singleton(new CoreModule());
    }

    private Collection<? extends Module> builderModules() {
        String nameOverride;
        ArrayList<Module> modules = new ArrayList<Module>();
        if (!this.configs.isEmpty()) {
            modules.add(binder -> {
                CoreModuleExtender extender = CoreModule.extend(binder);
                this.configs.forEach(extender::addProjectLocation);
            });
        }
        if ((nameOverride = this.name) == null && this.configs.size() != 1) {
            nameOverride = DEFAULT_NAME;
        }
        if (nameOverride != null) {
            String finalNameOverride = nameOverride;
            modules.add(binder -> CoreModule.extend(binder).setProperty("cayenne.domain.name", finalNameOverride));
        }
        if (this.dataSourceFactory != null) {
            modules.add(binder -> {
                binder.bind(DataDomain.class).toProvider(SyntheticNodeDataDomainProvider.class);
                binder.bind(DataSourceFactory.class).toInstance(this.dataSourceFactory);
            });
        } else if (this.jdbcUrl != null && this.jdbcDriver != null) {
            modules.add(binder -> {
                binder.bind(DataDomain.class).toProvider(SyntheticNodeDataDomainProvider.class);
                CoreModuleExtender extender = CoreModule.extend(binder).setProperty("cayenne.jdbc.driver", this.jdbcDriver).setProperty("cayenne.jdbc.url", this.jdbcUrl);
                if (this.jdbcUser != null) {
                    extender.setProperty("cayenne.jdbc.username", this.jdbcUser);
                }
                if (this.jdbcPassword != null) {
                    extender.setProperty("cayenne.jdbc.password", this.jdbcPassword);
                }
                if (this.jdbcMinConnections > 0) {
                    extender.setProperty("cayenne.jdbc.min_connections", Integer.toString(this.jdbcMinConnections));
                }
                if (this.jdbcMaxConnections > 0) {
                    extender.setProperty("cayenne.jdbc.max_connections", Integer.toString(this.jdbcMaxConnections));
                }
                if (this.maxQueueWaitTime > 0L) {
                    extender.setProperty("cayenne.jdbc.max_wait", Long.toString(this.maxQueueWaitTime));
                }
                if (this.validationQuery != null) {
                    extender.setProperty("cayenne.jdbc.validation_query", this.validationQuery);
                }
            });
        }
        return modules;
    }
}

