/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.ClassLoaderManager;
import org.apache.cayenne.di.DIRuntimeException;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.spi.ConstructorInjectingProvider;
import org.apache.cayenne.di.spi.DefaultInjector;
import org.apache.cayenne.di.spi.FieldInjectingProvider;

public class DefaultAdhocObjectFactory
implements AdhocObjectFactory {
    protected Injector injector;
    protected ClassLoaderManager classLoaderManager;

    public DefaultAdhocObjectFactory(@Inject Injector injector, @Inject ClassLoaderManager classLoaderManager) {
        this.injector = injector;
        this.classLoaderManager = classLoaderManager;
    }

    @Override
    public <T> T newInstance(Class<? super T> superType, String className) {
        Object instance;
        if (superType == null) {
            throw new NullPointerException("Null superType");
        }
        if (className == null) {
            throw new NullPointerException("Null className");
        }
        Class<?> type = this.getJavaClass(className);
        if (!superType.isAssignableFrom(type)) {
            throw new DIRuntimeException("Class %s is not assignable to %s", className, superType.getName());
        }
        try {
            ConstructorInjectingProvider provider0 = new ConstructorInjectingProvider(type, (DefaultInjector)this.injector);
            FieldInjectingProvider provider1 = new FieldInjectingProvider(provider0, (DefaultInjector)this.injector);
            instance = provider1.get();
        }
        catch (Exception e) {
            throw new DIRuntimeException("Error creating instance of class %s of type %s", (Throwable)e, className, superType.getName());
        }
        return instance;
    }

    public Class<?> getJavaClass(String className) {
        if (className == null) {
            throw new NullPointerException("Null class name");
        }
        ClassLoader classLoader = this.classLoaderManager.getClassLoader(((String)className).replace('.', '/'));
        try {
            return Class.forName((String)className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            if (!((String)className).endsWith("[]")) {
                switch (className) {
                    case "byte": {
                        return Byte.TYPE;
                    }
                    case "int": {
                        return Integer.TYPE;
                    }
                    case "short": {
                        return Short.TYPE;
                    }
                    case "char": {
                        return Character.TYPE;
                    }
                    case "double": {
                        return Double.TYPE;
                    }
                    case "long": {
                        return Long.TYPE;
                    }
                    case "float": {
                        return Float.TYPE;
                    }
                    case "boolean": {
                        return Boolean.TYPE;
                    }
                    case "void": {
                        return Void.TYPE;
                    }
                }
                int dot = ((String)className).lastIndexOf(46);
                if (dot > 0 && dot + 1 < ((String)className).length()) {
                    className = ((String)className).substring(0, dot) + "$" + ((String)className).substring(dot + 1);
                    try {
                        return Class.forName((String)className, true, classLoader);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                throw new DIRuntimeException("Invalid class: '%s'", (Throwable)e, className);
            }
            if (((String)className).length() < 3) {
                throw new IllegalArgumentException("Invalid class name: '" + (String)className + "'");
            }
            className = ((String)className).substring(0, ((String)className).length() - 2);
            switch (className) {
                case "byte": {
                    return byte[].class;
                }
                case "int": {
                    return int[].class;
                }
                case "long": {
                    return long[].class;
                }
                case "short": {
                    return short[].class;
                }
                case "char": {
                    return char[].class;
                }
                case "double": {
                    return double[].class;
                }
                case "float": {
                    return float[].class;
                }
                case "boolean": {
                    return boolean[].class;
                }
            }
            try {
                return Class.forName("[L" + (String)className + ";", true, classLoader);
            }
            catch (ClassNotFoundException e1) {
                throw new DIRuntimeException("Invalid class: '%s'", (Throwable)e1, className);
            }
        }
    }
}

