/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.value;

import java.time.LocalTime;
import java.util.Objects;
import org.apache.cayenne.crypto.transformer.value.BytesConverter;
import org.apache.cayenne.crypto.transformer.value.LongConverter;

public class LocalTimeConverter
implements BytesConverter<LocalTime> {
    public static final BytesConverter<LocalTime> INSTANCE = new LocalTimeConverter(LongConverter.INSTANCE);
    private BytesConverter<Long> longConverter;

    public LocalTimeConverter(BytesConverter<Long> longConverter) {
        this.longConverter = Objects.requireNonNull(longConverter);
    }

    @Override
    public LocalTime fromBytes(byte[] bytes) {
        return LocalTime.ofNanoOfDay(this.longConverter.fromBytes(bytes));
    }

    @Override
    public byte[] toBytes(LocalTime value) {
        return this.longConverter.toBytes(value.toNanoOfDay());
    }
}

