/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri;

import org.apache.commons.jxpath.JXPathContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StressTest {
    private static final int THREAD_COUNT = 50;
    private static final int THREAD_DURATION = 1000;
    private static JXPathContext context;
    private static int count;
    private static Throwable exception;

    @Test
    public void testThreads() throws Throwable {
        context = JXPathContext.newContext(null, (Object)100.0);
        Thread[] threadArray = new Thread[50];
        for (int i = 0; i < 50; ++i) {
            threadArray[i] = new Thread(new StressRunnable());
        }
        for (Thread element : threadArray) {
            element.start();
        }
        for (Thread element : threadArray) {
            try {
                element.join();
            }
            catch (InterruptedException e) {
                Assertions.fail((String)"Interrupted");
            }
        }
        if (exception != null) {
            throw exception;
        }
        Assertions.assertEquals((int)50000, (int)count, (String)"Test count");
    }

    private static final class StressRunnable
    implements Runnable {
        private StressRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (int j = 0; j < 1000 && exception == null; ++j) {
                try {
                    double random = 1.0 + Math.random();
                    double sum = (Double)context.getValue("/ + " + random);
                    Assertions.assertEquals((double)1.0E-4, (double)sum, (double)(100.0 + random));
                    JXPathContext jXPathContext = context;
                    synchronized (jXPathContext) {
                        count++;
                        continue;
                    }
                }
                catch (Throwable t) {
                    exception = t;
                }
            }
        }
    }
}

