/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.dom;

import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TestDOMFactory
extends AbstractFactory {
    private void addDOMElement(Node parent, int index, String tag, String namespaceURI) {
        int count = 0;
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals(tag)) continue;
            ++count;
        }
        while (count <= index) {
            Document doc = parent.getOwnerDocument();
            Element newElement = namespaceURI == null ? doc.createElement(tag) : doc.createElementNS(namespaceURI, tag);
            parent.appendChild(newElement);
            ++count;
        }
    }

    public boolean createObject(JXPathContext context, Pointer pointer, Object parent, String name, int index) {
        if (name.equals("location") || name.equals("address") || name.equals("street")) {
            this.addDOMElement((Node)parent, index, name, null);
            return true;
        }
        if (name.startsWith("price:")) {
            String namespaceURI = context.getNamespaceURI("price");
            this.addDOMElement((Node)parent, index, name, namespaceURI);
            return true;
        }
        return false;
    }

    public boolean declareVariable(JXPathContext context, String name) {
        return false;
    }
}

