/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.config.parameters;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.apache.rat.ConfigurationException;
import org.apache.rat.ImplementationException;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.config.parameters.ComponentType;
import org.apache.rat.config.parameters.ConfigComponent;
import org.apache.rat.config.parameters.Description;
import org.apache.rat.config.parameters.MatcherBuilder;
import org.apache.rat.license.ILicense;

public final class DescriptionBuilder {
    private DescriptionBuilder() {
    }

    public static Description build(Object object) {
        if (object instanceof ILicense) {
            ILicense license = (ILicense)object;
            Class<?> clazz = object.getClass();
            ConfigComponent configComponent = clazz.getAnnotation(ConfigComponent.class);
            if (configComponent == null || configComponent.type() != ComponentType.LICENSE) {
                throw new ConfigurationException(String.format("Licenses must have License type specified in ConfigComponent annotation. Annotation missing or incorrect in %s", clazz));
            }
            List<Description> children = DescriptionBuilder.getConfigComponents(object.getClass());
            return new Description(ComponentType.LICENSE, license.getId(), license.getName(), false, null, children, false);
        }
        return DescriptionBuilder.buildMap(object.getClass());
    }

    private static String fixupMethodName(Method method) {
        String name = method.getName();
        if ((name.startsWith("get") || name.startsWith("set") || name.startsWith("add")) && name.length() > 3) {
            return WordUtils.uncapitalize(name.substring(3));
        }
        throw new ImplementationException(String.format("'%s' is not a recognized method name", name));
    }

    static List<Description> getConfigComponents(Class<?> clazz) {
        Description desc;
        boolean isCollection;
        Class<?> childClazz;
        String name;
        ConfigComponent configComponent;
        if (clazz == null || clazz == String.class || clazz == Object.class) {
            return Collections.emptyList();
        }
        ArrayList<Description> result = new ArrayList<Description>();
        for (Field field : clazz.getDeclaredFields()) {
            configComponent = field.getAnnotation(ConfigComponent.class);
            if (configComponent == null) continue;
            name = StringUtils.isBlank(configComponent.name()) ? field.getName() : configComponent.name();
            childClazz = configComponent.parameterType() == Void.TYPE ? field.getType() : configComponent.parameterType();
            isCollection = Iterable.class.isAssignableFrom(field.getType());
            desc = new Description(configComponent.type(), name, configComponent.desc(), isCollection, childClazz, DescriptionBuilder.getConfigComponents(childClazz), configComponent.required());
            result.add(desc);
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
            configComponent = ((Method)accessibleObject).getAnnotation(ConfigComponent.class);
            if (configComponent == null) continue;
            name = StringUtils.isBlank(configComponent.name()) ? DescriptionBuilder.fixupMethodName((Method)accessibleObject) : configComponent.name();
            childClazz = configComponent.parameterType() == Void.TYPE ? ((Method)accessibleObject).getReturnType() : configComponent.parameterType();
            isCollection = Iterable.class.isAssignableFrom(((Method)accessibleObject).getReturnType());
            desc = new Description(configComponent.type(), name, configComponent.desc(), isCollection, childClazz, DescriptionBuilder.getConfigComponents(childClazz), configComponent.required());
            result.add(desc);
        }
        result.addAll(DescriptionBuilder.getConfigComponents(clazz.getSuperclass()));
        Arrays.stream(clazz.getInterfaces()).forEach(c -> result.addAll(DescriptionBuilder.getConfigComponents(c)));
        return result;
    }

    private static ConfigComponent findConfigComponent(Class<?> clazz) {
        if (clazz == null || clazz == String.class || clazz == Object.class) {
            return null;
        }
        ConfigComponent configComponent = clazz.getAnnotation(ConfigComponent.class);
        return configComponent == null ? DescriptionBuilder.findConfigComponent(clazz.getSuperclass()) : configComponent;
    }

    public static Class<?> getBuiltClass(Class<? extends IHeaderMatcher.Builder> clazz) {
        try {
            MatcherBuilder matcherBuilder = clazz.getAnnotation(MatcherBuilder.class);
            if (matcherBuilder == null) {
                return clazz.getMethod("build", new Class[0]).getReturnType();
            }
            return matcherBuilder.value();
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException("The 'build' method of the Builder interface must always be public");
        }
    }

    public static Description buildMap(Class<?> clazz) {
        if (clazz == IHeaderMatcher.class) {
            throw new ImplementationException("'clazz' parameter must not be IHeaderMatcher.class but may be a child of it");
        }
        Class<?> workingClass = IHeaderMatcher.Builder.class.isAssignableFrom(clazz) ? DescriptionBuilder.getBuiltClass(clazz) : clazz;
        ConfigComponent configComponent = DescriptionBuilder.findConfigComponent(workingClass);
        if (configComponent == null) {
            return null;
        }
        List<Description> children = DescriptionBuilder.getConfigComponents(workingClass);
        return new Description(configComponent, false, null, children);
    }
}

