/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.license;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.IHeaders;
import org.apache.rat.license.ILicense;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.utils.Log;
import org.apache.rat.utils.ReportingSet;

public class LicenseSetFactory {
    private final ReportingSet<ILicenseFamily> families = new ReportingSet(new TreeSet()).setMsgFormat(s -> String.format("Duplicate LicenseFamily category: %s", s.getFamilyCategory()));
    private final ReportingSet<ILicense> licenses = new ReportingSet(new TreeSet()).setMsgFormat(s -> String.format("Duplicate License %s (%s) of type %s", s.getName(), s.getId(), s.getLicenseFamily().getFamilyCategory()));
    private final SortedSet<String> approvedLicenseCategories = new TreeSet<String>();
    private final SortedSet<String> removedLicenseCategories = new TreeSet<String>();
    private final SortedSet<String> approvedLicenseIds = new TreeSet<String>();
    private final SortedSet<String> removedLicenseIds = new TreeSet<String>();

    public static ILicenseFamily familySearch(String target, SortedSet<ILicenseFamily> licenseFamilies) {
        ILicenseFamily family = ILicenseFamily.builder().setLicenseFamilyCategory(target).setLicenseFamilyName("Searching family").build();
        return LicenseSetFactory.familySearch(family, licenseFamilies);
    }

    public static ILicenseFamily familySearch(ILicenseFamily target, SortedSet<ILicenseFamily> licenseFamilies) {
        SortedSet<ILicenseFamily> part = licenseFamilies.tailSet(target);
        return !part.isEmpty() && part.first().compareTo(target) == 0 ? part.first() : null;
    }

    public LicenseSetFactory() {
    }

    public LicenseSetFactory(SortedSet<ILicense> licenses) {
        this();
        this.licenses.addAll((Collection<ILicense>)licenses);
        licenses.forEach(l -> this.families.addIfNotPresent(l.getLicenseFamily()));
    }

    public void add(LicenseSetFactory other) {
        this.families.addAll((Collection<ILicenseFamily>)other.families);
        this.licenses.addAll((Collection<ILicense>)other.licenses);
        this.approvedLicenseCategories.addAll(other.approvedLicenseCategories);
        this.removedLicenseCategories.addAll(other.removedLicenseCategories);
        this.approvedLicenseIds.addAll(other.approvedLicenseIds);
        this.removedLicenseIds.addAll(other.removedLicenseIds);
    }

    public void logFamilyCollisions(Log.Level level) {
        this.families.setLogLevel(level);
    }

    public void familyDuplicateOption(ReportingSet.Options state) {
        this.families.setDuplicateOption(state);
    }

    public void logLicenseCollisions(Log.Level level) {
        this.licenses.setLogLevel(level);
    }

    public void licenseDuplicateOption(ReportingSet.Options state) {
        this.licenses.setDuplicateOption(state);
    }

    private static SortedSet<ILicenseFamily> extractFamily(Collection<ILicense> licenses) {
        TreeSet<ILicenseFamily> result = new TreeSet<ILicenseFamily>();
        licenses.stream().map(ILicense::getLicenseFamily).forEach(result::add);
        return result;
    }

    public void addLicense(ILicense license) {
        if (license != null) {
            this.licenses.add(license);
            this.families.addIfNotPresent(license.getLicenseFamily());
        }
    }

    public ILicense addLicense(ILicense.Builder builder) {
        if (builder != null) {
            ILicense license = builder.setLicenseFamilies(this.families).build();
            this.licenses.add(license);
            return license;
        }
        return null;
    }

    public void addLicenses(Collection<ILicense> licenses) {
        this.licenses.addAll(licenses);
        licenses.stream().map(ILicense::getLicenseFamily).forEach(this.families::add);
    }

    public void addFamily(ILicenseFamily family) {
        if (family != null) {
            this.families.add(family);
        }
    }

    public void addFamily(ILicenseFamily.Builder builder) {
        if (builder != null) {
            this.families.add(builder.build());
        }
    }

    public void addLicenseCategory(String familyCategory) {
        this.approvedLicenseCategories.add(ILicenseFamily.makeCategory(familyCategory));
    }

    public void removeLicenseCategory(String familyCategory) {
        this.removedLicenseCategories.add(ILicenseFamily.makeCategory(familyCategory));
    }

    public void addLicenseId(String licenseId) {
        this.approvedLicenseIds.add(licenseId);
    }

    public void removeLicenseId(String licenseId) {
        this.removedLicenseIds.add(licenseId);
    }

    private boolean isApprovedCategory(ILicenseFamily family) {
        return this.approvedLicenseCategories.contains(family.getFamilyCategory()) && !this.removedLicenseCategories.contains(family.getFamilyCategory());
    }

    public SortedSet<ILicense> getLicenses(LicenseFilter filter) {
        Predicate<ILicense> approved = l -> (this.isApprovedCategory(l.getLicenseFamily()) || this.approvedLicenseIds.contains(l.getId())) && !this.removedLicenseIds.contains(l.getId());
        switch (filter) {
            case ALL: {
                return Collections.unmodifiableSortedSet(this.licenses);
            }
            case APPROVED: {
                TreeSet<ILicense> result = new TreeSet<ILicense>();
                this.licenses.stream().filter(approved).forEach(result::add);
                return result;
            }
        }
        return Collections.emptySortedSet();
    }

    public SortedSet<ILicenseFamily> getLicenseFamilies(LicenseFilter filter) {
        switch (filter) {
            case ALL: {
                SortedSet<ILicenseFamily> result = LicenseSetFactory.extractFamily(this.licenses);
                result.addAll(this.families);
                return result;
            }
            case APPROVED: {
                TreeSet<ILicenseFamily> result = new TreeSet<ILicenseFamily>();
                this.licenses.stream().map(ILicense::getLicenseFamily).filter(this::isApprovedCategory).forEach(result::add);
                return result;
            }
        }
        return Collections.emptySortedSet();
    }

    public SortedSet<String> getLicenseCategories(LicenseFilter filter) {
        Predicate<ILicense> approved = l -> (this.isApprovedCategory(l.getLicenseFamily()) || this.approvedLicenseIds.contains(l.getId())) && !this.removedLicenseIds.contains(l.getId());
        TreeSet<String> result = new TreeSet<String>();
        switch (filter) {
            case ALL: {
                this.licenses.forEach(l -> result.add(l.getLicenseFamily().getFamilyCategory()));
                this.families.forEach(f -> result.add(f.getFamilyCategory()));
                result.addAll(this.approvedLicenseCategories);
                result.addAll(this.removedLicenseCategories);
                return result;
            }
            case APPROVED: {
                this.approvedLicenseCategories.stream().filter(s -> !this.removedLicenseCategories.contains(s)).forEach(result::add);
                this.licenses.stream().filter(approved).forEach(l -> result.add(l.getLicenseFamily().getFamilyCategory()));
                this.families.stream().filter(this::isApprovedCategory).forEach(f -> result.add(f.getFamilyCategory()));
                return result;
            }
        }
        return Collections.emptySortedSet();
    }

    public SortedSet<String> getLicenseIds(LicenseFilter filter) {
        Predicate<ILicense> approved = l -> (this.isApprovedCategory(l.getLicenseFamily()) || this.approvedLicenseIds.contains(l.getId())) && !this.removedLicenseIds.contains(l.getId());
        TreeSet<String> result = new TreeSet<String>();
        switch (filter) {
            case ALL: {
                this.licenses.forEach(l -> result.add(l.getId()));
                result.addAll(this.approvedLicenseCategories);
                result.addAll(this.removedLicenseCategories);
                result.addAll(this.approvedLicenseIds);
                result.addAll(this.removedLicenseIds);
                return result;
            }
            case APPROVED: {
                this.licenses.stream().filter(approved).forEach(l -> result.add(l.getId()));
                this.families.stream().filter(this::isApprovedCategory).forEach(f -> result.add(f.getFamilyCategory()));
                this.approvedLicenseIds.stream().filter(s -> !this.removedLicenseIds.contains(s)).forEach(result::add);
                return result;
            }
        }
        return Collections.emptySortedSet();
    }

    public static Optional<ILicense> search(String familyId, final String licenseId, SortedSet<ILicense> licenses) {
        final ILicenseFamily searchFamily = ILicenseFamily.builder().setLicenseFamilyCategory(familyId).setLicenseFamilyName("searching proxy").build();
        ILicense target = new ILicense(){

            @Override
            public String getId() {
                return licenseId;
            }

            @Override
            public void reset() {
            }

            @Override
            public boolean matches(IHeaders headers) {
                return false;
            }

            public boolean equals(Object o) {
                return ILicense.equals(this, o);
            }

            public int hashCode() {
                return ILicense.hash(this);
            }

            @Override
            public ILicenseFamily getLicenseFamily() {
                return searchFamily;
            }

            @Override
            public String getNote() {
                return null;
            }

            @Override
            public String getName() {
                return searchFamily.getFamilyName();
            }

            @Override
            public IHeaderMatcher getMatcher() {
                return null;
            }
        };
        return LicenseSetFactory.search(target, licenses);
    }

    public static Optional<ILicense> search(ILicense target, SortedSet<ILicense> licenses) {
        SortedSet<ILicense> part = licenses.tailSet(target);
        return Optional.ofNullable(!part.isEmpty() && part.first().compareTo(target) == 0 ? part.first() : null);
    }

    public static enum LicenseFilter {
        ALL,
        APPROVED,
        NONE;

    }
}

