/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.kll;

import org.apache.datasketches.hive.kll.GetQuantileUDF;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetQuantileUDFTest {
    @Test
    public void nullSketch() {
        Float result = new GetQuantileUDF().evaluate(null, 0.0);
        Assert.assertNull((Object)result);
    }

    @Test
    public void normalCase() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        sketch.update(1.0f);
        sketch.update(2.0f);
        sketch.update(3.0f);
        sketch.update(4.0f);
        Float result = new GetQuantileUDF().evaluate(new BytesWritable(sketch.toByteArray()), 0.5);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)result.floatValue(), (double)2.0);
        result = new GetQuantileUDF().evaluate(new BytesWritable(sketch.toByteArray()), Boolean.valueOf(false), 0.5);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((double)result.floatValue(), (double)3.0);
    }
}

