/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import jdk.incubator.foreign.ResourceScope;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.ResourceImpl;
import org.apache.datasketches.memory.internal.UtilTest;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.testng.collections.Lists;

public class MemoryTest {
    final MemoryRequestServer myMemReqSvr = Resource.defaultMemReqSvr;

    @BeforeClass
    public void setReadOnly() throws IOException {
        UtilTest.setGettysburgAddressFileToReadOnly();
    }

    @Test
    public void checkDirectRoundTrip() throws Exception {
        int n = 1024;
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            int i;
            WritableMemory mem = WritableMemory.allocateDirect((long)(n * 8), (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)this.myMemReqSvr);
            for (i = 0; i < n; ++i) {
                mem.putLong((long)(i * 8), (long)i);
            }
            for (i = 0; i < n; ++i) {
                long v = mem.getLong((long)(i * 8));
                Assert.assertEquals((long)v, (long)i);
            }
        }
    }

    @Test
    public void checkAutoHeapRoundTrip() {
        int i;
        int n = 1024;
        WritableMemory wmem = WritableMemory.allocate((int)(n * 8));
        for (i = 0; i < n; ++i) {
            wmem.putLong((long)(i * 8), (long)i);
        }
        for (i = 0; i < n; ++i) {
            long v = wmem.getLong((long)(i * 8));
            Assert.assertEquals((long)v, (long)i);
        }
    }

    @Test
    public void checkArrayWrap() {
        int i;
        int n = 1024;
        byte[] arr = new byte[n * 8];
        WritableMemory wmem = WritableMemory.writableWrap((byte[])arr);
        for (i = 0; i < n; ++i) {
            wmem.putLong((long)(i * 8), (long)i);
        }
        for (i = 0; i < n; ++i) {
            long v = wmem.getLong((long)(i * 8));
            Assert.assertEquals((long)v, (long)i);
        }
        Memory mem = Memory.wrap((byte[])arr, (ByteOrder)ByteOrder.nativeOrder());
        for (int i2 = 0; i2 < n; ++i2) {
            long v = mem.getLong((long)(i2 * 8));
            Assert.assertEquals((long)v, (long)i2);
        }
        WritableMemory memZeroLengthArrayByte = WritableMemory.writableWrap((byte[])new byte[0]);
        WritableMemory memZeroLengthArrayChar = WritableMemory.writableWrap((char[])new char[0]);
        WritableMemory memZeroLengthArrayShort = WritableMemory.writableWrap((short[])new short[0]);
        WritableMemory memZeroLengthArrayInt = WritableMemory.writableWrap((int[])new int[0]);
        WritableMemory memZeroLengthArrayLong = WritableMemory.writableWrap((long[])new long[0]);
        WritableMemory memZeroLengthArrayFloat = WritableMemory.writableWrap((float[])new float[0]);
        WritableMemory memZeroLengthArrayDouble = WritableMemory.writableWrap((double[])new double[0]);
        Assert.assertEquals((long)memZeroLengthArrayByte.getCapacity(), (long)0L);
        Assert.assertEquals((long)memZeroLengthArrayChar.getCapacity(), (long)0L);
        Assert.assertEquals((long)memZeroLengthArrayShort.getCapacity(), (long)0L);
        Assert.assertEquals((long)memZeroLengthArrayInt.getCapacity(), (long)0L);
        Assert.assertEquals((long)memZeroLengthArrayLong.getCapacity(), (long)0L);
        Assert.assertEquals((long)memZeroLengthArrayFloat.getCapacity(), (long)0L);
        Assert.assertEquals((long)memZeroLengthArrayDouble.getCapacity(), (long)0L);
        List memoryToCheck = Lists.newArrayList();
        memoryToCheck.add(WritableMemory.allocate((int)0));
        memoryToCheck.add(WritableMemory.writableWrap((ByteBuffer)ByteBuffer.allocate(0)));
        memoryToCheck.add(WritableMemory.writableWrap((byte[])new byte[0]));
        memoryToCheck.add(WritableMemory.writableWrap((char[])new char[0]));
        memoryToCheck.add(WritableMemory.writableWrap((short[])new short[0]));
        memoryToCheck.add(WritableMemory.writableWrap((int[])new int[0]));
        memoryToCheck.add(WritableMemory.writableWrap((long[])new long[0]));
        memoryToCheck.add(WritableMemory.writableWrap((float[])new float[0]));
        memoryToCheck.add(WritableMemory.writableWrap((double[])new double[0]));
        memoryToCheck.add(Memory.wrap((ByteBuffer)ByteBuffer.allocate(0)));
        memoryToCheck.add(Memory.wrap((byte[])new byte[0]));
        memoryToCheck.add(Memory.wrap((char[])new char[0]));
        memoryToCheck.add(Memory.wrap((short[])new short[0]));
        memoryToCheck.add(Memory.wrap((int[])new int[0]));
        memoryToCheck.add(Memory.wrap((long[])new long[0]));
        memoryToCheck.add(Memory.wrap((float[])new float[0]));
        memoryToCheck.add(Memory.wrap((double[])new double[0]));
        for (Memory memory : memoryToCheck) {
            Assert.assertEquals((long)memory.getCapacity(), (long)0L);
        }
    }

    @Test
    public void checkByteBufHeap() {
        long v;
        int i;
        int n = 1024;
        byte[] arr = new byte[n * 8];
        ByteBuffer bb = ByteBuffer.wrap(arr);
        bb.order(ByteOrder.nativeOrder());
        WritableMemory wmem = WritableMemory.writableWrap((ByteBuffer)bb);
        for (i = 0; i < n; ++i) {
            wmem.putLong((long)(i * 8), (long)i);
        }
        for (i = 0; i < n; ++i) {
            v = wmem.getLong((long)(i * 8));
            Assert.assertEquals((long)v, (long)i);
        }
        for (i = 0; i < n; ++i) {
            v = bb.getLong(i * 8);
            Assert.assertEquals((long)v, (long)i);
        }
        Memory mem1 = Memory.wrap((byte[])arr);
        for (int i2 = 0; i2 < n; ++i2) {
            long v2 = mem1.getLong((long)(i2 * 8));
            Assert.assertEquals((long)v2, (long)i2);
        }
        WritableMemory mem = wmem;
        for (int i3 = 0; i3 < n; ++i3) {
            long v3 = mem.getLong((long)(i3 * 8));
            Assert.assertEquals((long)v3, (long)i3);
        }
    }

    @Test
    public void checkByteBufferNonNativeHeap() {
        long v;
        int i;
        int n = 10;
        byte[] arr = new byte[n * 8];
        ByteBuffer bb = ByteBuffer.wrap(arr);
        WritableMemory wmem = WritableMemory.writableWrap((ByteBuffer)bb, (ByteOrder)ResourceImpl.NON_NATIVE_BYTE_ORDER, (MemoryRequestServer)this.myMemReqSvr);
        for (i = 0; i < n; ++i) {
            wmem.putLong((long)(i * 8), (long)i);
        }
        for (i = 0; i < n; ++i) {
            v = wmem.getLong((long)(i * 8));
            Assert.assertEquals((long)v, (long)i);
        }
        for (i = 0; i < n; ++i) {
            v = bb.getLong(i * 8);
            Assert.assertEquals((long)v, (long)i);
        }
        Memory mem1 = Memory.wrap((byte[])arr, (ByteOrder)ResourceImpl.NON_NATIVE_BYTE_ORDER);
        for (int i2 = 0; i2 < n; ++i2) {
            long v2 = mem1.getLong((long)(i2 * 8));
            Assert.assertEquals((long)v2, (long)i2);
        }
        WritableMemory mem = wmem;
        for (int i3 = 0; i3 < n; ++i3) {
            long v3 = mem.getLong((long)(i3 * 8));
            Assert.assertEquals((long)v3, (long)i3);
        }
    }

    @Test
    public void checkByteBufDirect() {
        long v;
        int i;
        int n = 1024;
        ByteBuffer bb = ByteBuffer.allocateDirect(n * 8);
        bb.order(ByteOrder.nativeOrder());
        WritableMemory wmem = WritableMemory.writableWrap((ByteBuffer)bb);
        for (i = 0; i < n; ++i) {
            wmem.putLong((long)(i * 8), (long)i);
        }
        for (i = 0; i < n; ++i) {
            v = wmem.getLong((long)(i * 8));
            Assert.assertEquals((long)v, (long)i);
        }
        for (i = 0; i < n; ++i) {
            v = bb.getLong(i * 8);
            Assert.assertEquals((long)v, (long)i);
        }
        Memory mem1 = Memory.wrap((ByteBuffer)bb);
        for (int i2 = 0; i2 < n; ++i2) {
            long v2 = mem1.getLong((long)(i2 * 8));
            Assert.assertEquals((long)v2, (long)i2);
        }
        WritableMemory mem = wmem;
        for (int i3 = 0; i3 < n; ++i3) {
            long v3 = mem.getLong((long)(i3 * 8));
            Assert.assertEquals((long)v3, (long)i3);
        }
    }

    @Test
    public void checkByteBufOrderIgnored() {
        int n = 1024;
        ByteBuffer bb = ByteBuffer.allocate(n * 8);
        bb.order(ByteOrder.BIG_ENDIAN);
        Memory mem = Memory.wrap((ByteBuffer)bb);
        Assert.assertTrue((mem.getTypeByteOrder() == ByteOrder.nativeOrder() ? 1 : 0) != 0);
        Assert.assertEquals((Object)mem.getTypeByteOrder(), (Object)ByteOrder.LITTLE_ENDIAN);
        mem = Memory.wrap((ByteBuffer)bb, (ByteOrder)ResourceImpl.NON_NATIVE_BYTE_ORDER);
        Assert.assertFalse((mem.getTypeByteOrder() == ByteOrder.nativeOrder() ? 1 : 0) != 0);
        Assert.assertEquals((Object)mem.getTypeByteOrder(), (Object)ByteOrder.BIG_ENDIAN);
    }

    @Test
    public void checkReadOnlyHeapByteBuffer() {
        ByteBuffer bb = ByteBuffer.allocate(128);
        bb.order(ByteOrder.nativeOrder());
        for (int i = 0; i < 128; ++i) {
            bb.put(i, (byte)i);
        }
        bb.position(64);
        ByteBuffer slice = bb.slice().asReadOnlyBuffer();
        slice.order(ByteOrder.nativeOrder());
        Memory mem = Memory.wrap((ByteBuffer)slice);
        for (int i = 0; i < 64; ++i) {
            Assert.assertEquals((int)mem.getByte((long)i), (int)(64 + i));
        }
        String s = mem.toString("slice", 0L, slice.capacity(), true);
        MemoryTest.println(s);
    }

    @Test
    public void checkPutGetArraysHeap() {
        int n = 1024;
        long[] arr = new long[n];
        for (int i = 0; i < n; ++i) {
            arr[i] = i;
        }
        WritableMemory wmem = WritableMemory.allocate((int)(n * 8));
        wmem.putLongArray(0L, arr, 0, n);
        long[] arr2 = new long[n];
        wmem.getLongArray(0L, arr2, 0, n);
        for (int i = 0; i < n; ++i) {
            Assert.assertEquals((long)arr2[i], (long)i);
        }
    }

    @Test
    public void checkRORegions() {
        int n = 16;
        int n2 = n / 2;
        long[] arr = new long[n];
        for (int i = 0; i < n; ++i) {
            arr[i] = i;
        }
        Memory mem = Memory.wrap((long[])arr);
        Memory reg = mem.region((long)(n2 * 8), (long)(n2 * 8));
        for (int i = 0; i < n2; ++i) {
            long v = reg.getLong((long)(i * 8));
            long e = i + n2;
            Assert.assertEquals((long)v, (long)e);
        }
    }

    @Test
    public void checkRORegionsReverseBO() {
        int n = 16;
        int n2 = n / 2;
        long[] arr = new long[n];
        for (int i = 0; i < n; ++i) {
            arr[i] = i;
        }
        Memory mem = Memory.wrap((long[])arr);
        Memory reg = mem.region((long)(n2 * 8), (long)(n2 * 8), ResourceImpl.NON_NATIVE_BYTE_ORDER);
        for (int i = 0; i < n2; ++i) {
            long v = Long.reverseBytes(reg.getLong((long)(i * 8)));
            long e = i + n2;
            Assert.assertEquals((long)v, (long)e);
        }
    }

    @Test
    public void checkWRegions() {
        int i;
        int n = 16;
        int n2 = n / 2;
        long[] arr = new long[n];
        for (int i2 = 0; i2 < n; ++i2) {
            arr[i2] = i2;
        }
        WritableMemory wmem = WritableMemory.writableWrap((long[])arr);
        for (int i3 = 0; i3 < n; ++i3) {
            Assert.assertEquals((long)wmem.getLong((long)(i3 * 8)), (long)i3);
        }
        WritableMemory reg = wmem.writableRegion((long)(n2 * 8), (long)(n2 * 8));
        for (i = 0; i < n2; ++i) {
            reg.putLong((long)(i * 8), (long)i);
        }
        for (i = 0; i < n; ++i) {
            Assert.assertEquals((long)wmem.getLong((long)(i * 8)), (long)(i % 8));
        }
    }

    @Test
    public void checkWRegionsReverseBO() {
        int i;
        int n = 16;
        int n2 = n / 2;
        long[] arr = new long[n];
        for (int i2 = 0; i2 < n; ++i2) {
            arr[i2] = i2;
        }
        WritableMemory wmem = WritableMemory.writableWrap((long[])arr);
        for (int i3 = 0; i3 < n; ++i3) {
            Assert.assertEquals((long)wmem.getLong((long)(i3 * 8)), (long)i3);
        }
        WritableMemory reg = wmem.writableRegion((long)(n2 * 8), (long)(n2 * 8), ResourceImpl.NON_NATIVE_BYTE_ORDER);
        for (i = 0; i < n2; ++i) {
            reg.putLong((long)(i * 8), (long)i);
        }
        for (i = 0; i < n; ++i) {
            long v = wmem.getLong((long)(i * 8));
            if (i < n2) {
                Assert.assertEquals((long)v, (long)(i % 8));
                continue;
            }
            Assert.assertEquals((long)Long.reverseBytes(v), (long)(i % 8));
        }
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void checkParentUseAfterFree() throws Exception {
        int bytes = 512;
        ResourceScope scope = ResourceScope.newConfinedScope();
        WritableMemory wmem = WritableMemory.allocateDirect((long)bytes, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)this.myMemReqSvr);
        wmem.close();
        wmem.getLong(0L);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void checkRegionUseAfterFree() throws Exception {
        int bytes = 64;
        ResourceScope scope = ResourceScope.newConfinedScope();
        WritableMemory wmem = WritableMemory.allocateDirect((long)bytes, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)this.myMemReqSvr);
        Memory region = wmem.region(0L, (long)bytes);
        wmem.close();
        region.getByte(0L);
    }

    @Test
    public void checkMemReqSvr() throws Exception {
        WritableMemory wmem = WritableMemory.writableWrap((byte[])new byte[16]);
        Assert.assertNull((Object)wmem.getMemoryRequestServer());
        WritableBuffer wbuf = wmem.asWritableBuffer();
        Assert.assertNull((Object)wbuf.getMemoryRequestServer());
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            wmem = WritableMemory.allocateDirect((long)16L, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)this.myMemReqSvr);
            Assert.assertNotNull((Object)wmem.getMemoryRequestServer());
            wbuf = wmem.asWritableBuffer();
            Assert.assertNotNull((Object)wbuf.getMemoryRequestServer());
        }
        ByteBuffer bb = ByteBuffer.allocate(16);
        wmem = WritableMemory.writableWrap((ByteBuffer)bb);
        wmem.setMemoryRequestServer(this.myMemReqSvr);
        Assert.assertNotNull((Object)wmem.getMemoryRequestServer());
        wbuf = wmem.asWritableBuffer();
        Assert.assertNull((Object)wbuf.getMemoryRequestServer());
        wmem = WritableMemory.writableWrap((byte[])new byte[16], (int)0, (int)16, (ByteOrder)ResourceImpl.NATIVE_BYTE_ORDER, (MemoryRequestServer)this.myMemReqSvr);
        Assert.assertNotNull((Object)wmem.getMemoryRequestServer());
        wbuf = wmem.asWritableBuffer();
        Assert.assertNotNull((Object)wbuf.getMemoryRequestServer());
        try (ResourceScope scope = ResourceScope.newConfinedScope();){
            WritableMemory wmem2 = WritableMemory.allocateDirect((long)16L, (long)1L, (ResourceScope)scope, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)this.myMemReqSvr);
            Assert.assertNotNull((Object)wmem2.getMemoryRequestServer());
            wbuf = wmem.asWritableBuffer();
            Assert.assertNotNull((Object)wbuf.getMemoryRequestServer());
        }
        bb = ByteBuffer.allocate(16);
        wmem = WritableMemory.writableWrap((ByteBuffer)bb);
        Assert.assertNull((Object)wmem.getMemoryRequestServer());
        wbuf = wmem.asWritableBuffer();
        Assert.assertNull((Object)wbuf.getMemoryRequestServer());
    }

    @Test
    public void checkSelfEqualsToAndCompareTo() {
        int len = 64;
        WritableMemory wmem = WritableMemory.allocate((int)len);
        for (int i = 0; i < len; ++i) {
            wmem.putByte((long)i, (byte)i);
        }
        Assert.assertTrue((boolean)wmem.equalTo(0L, (Resource)wmem, 0L, (long)len));
        Assert.assertFalse((boolean)wmem.equalTo(0L, (Resource)wmem, (long)(len / 2), (long)(len / 2)));
        Assert.assertEquals((int)wmem.compareTo(0L, (long)len, (Memory)wmem, 0L, (long)len), (int)0);
        Assert.assertTrue((wmem.compareTo(0L, 0L, (Memory)wmem, (long)(len / 2), (long)(len / 2)) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void wrapBigEndianAsLittle() {
        ByteBuffer bb = ByteBuffer.allocate(64);
        bb.putChar(0, '\u0001');
        Memory mem = Memory.wrap((ByteBuffer)bb, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        Assert.assertEquals((int)mem.getChar(0L), (int)256);
    }

    @Test
    public void checkIssue178() {
        int n = 8;
        byte[] bArr = new byte[n];
        for (int i = 0; i < n; ++i) {
            bArr[i] = (byte)i;
        }
        Memory mem = Memory.wrap((byte[])bArr, (int)(n / 2), (int)(n / 2), (ByteOrder)ByteOrder.nativeOrder());
        for (int i = 0; i < n / 2; ++i) {
            MemoryTest.println(mem.getByte((long)i));
            Assert.assertEquals((int)mem.getByte((long)i), (int)(n / 2 + i));
        }
    }

    @Test
    public void checkArrayBounds() {
        byte[] arr = new byte[100];
        int offset = 50;
        int len = 51;
        for (int i = 0; i < 100; ++i) {
            arr[i] = (byte)(i + 1);
        }
        try {
            Memory.wrap((byte[])arr, (int)offset, (int)len, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void checkByteOrder() {
        byte[] arr = new byte[4];
        int test = 1;
        arr[0] = (byte)test;
        Memory mem = Memory.wrap((byte[])arr, (ByteOrder)ByteOrder.BIG_ENDIAN);
        int t = mem.getInt(0L);
        Assert.assertEquals((int)t, (int)Integer.reverseBytes(test));
    }

    @Test
    public void printlnTest() {
        MemoryTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
        if (o == null) {
            MemoryTest.print(ResourceImpl.LS);
        } else {
            MemoryTest.print(o.toString() + ResourceImpl.LS);
        }
    }

    static void print(Object o) {
        if (o != null) {
            // empty if block
        }
    }
}

