/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import java.io.IOException;
import java.util.Random;
import org.apache.commons.math3.stat.inference.TTest;
import org.apache.datasketches.pig.tuple.ArrayOfDoublesSketchesToPValueEstimates;
import org.apache.datasketches.pig.tuple.PigUtil;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayOfDoublesSketchesToPValueEstimatesTest {
    @Test
    public void nullInput() throws IOException {
        ArrayOfDoublesSketchesToPValueEstimates func = new ArrayOfDoublesSketchesToPValueEstimates();
        Tuple resultTuple = (Tuple)func.exec(null);
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void emptyInput() throws IOException {
        ArrayOfDoublesSketchesToPValueEstimates func = new ArrayOfDoublesSketchesToPValueEstimates();
        Tuple resultTuple = (Tuple)func.exec(TupleFactory.getInstance().newTuple());
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void oneEmptySketch() throws IOException {
        ArrayOfDoublesSketchesToPValueEstimates func = new ArrayOfDoublesSketchesToPValueEstimates();
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        Tuple inputTuple = PigUtil.objectsToTuple(new DataByteArray(sketch.compact().toByteArray()));
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void twoEmptySketches() throws IOException {
        ArrayOfDoublesSketchesToPValueEstimates func = new ArrayOfDoublesSketchesToPValueEstimates();
        ArrayOfDoublesUpdatableSketch sketchA = new ArrayOfDoublesUpdatableSketchBuilder().build();
        ArrayOfDoublesUpdatableSketch sketchB = new ArrayOfDoublesUpdatableSketchBuilder().build();
        Tuple inputTuple = PigUtil.objectsToTuple(new DataByteArray(sketchA.compact().toByteArray()), new DataByteArray(sketchB.compact().toByteArray()));
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void smokerDatasetSingleMetric() throws IOException {
        int i;
        ArrayOfDoublesSketchesToPValueEstimates func = new ArrayOfDoublesSketchesToPValueEstimates();
        ArrayOfDoublesUpdatableSketch sketchA = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(1).setNominalEntries(16).build();
        ArrayOfDoublesUpdatableSketch sketchB = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(1).setNominalEntries(16).build();
        double[] groupA = new double[]{7.3, 6.5, 5.2, 6.3, 7.0, 5.9, 5.2, 5.0, 4.7, 5.7, 5.7, 3.3, 5.0, 4.6, 4.8, 3.8, 4.6};
        double[] groupB = new double[]{4.2, 4.0, 2.6, 4.9, 4.4, 4.4, 5.5, 5.1, 5.1, 3.2, 3.9, 3.2, 4.9, 4.3, 4.8, 2.4, 5.5, 5.5, 3.7};
        for (i = 0; i < groupA.length; ++i) {
            sketchA.update((long)i, new double[]{groupA[i]});
        }
        for (i = 0; i < groupB.length; ++i) {
            sketchB.update((long)i, new double[]{groupB[i]});
        }
        Tuple inputTuple = PigUtil.objectsToTuple(new DataByteArray(sketchA.compact().toByteArray()), new DataByteArray(sketchB.compact().toByteArray()));
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        Assert.assertEquals((double)((Double)resultTuple.get(0)), (double)0.0043, (double)1.0E-4);
    }

    @Test
    public void largeDataSet() throws IOException {
        double val;
        int i;
        ArrayOfDoublesSketchesToPValueEstimates func = new ArrayOfDoublesSketchesToPValueEstimates();
        ArrayOfDoublesUpdatableSketch sketchA = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(1).setNominalEntries(16000).build();
        ArrayOfDoublesUpdatableSketch sketchB = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(1).setNominalEntries(16000).build();
        int n = 100000;
        int bShift = 1000;
        double[] a = new double[n];
        double[] b = new double[n];
        Random rand = new Random(41L);
        for (i = 0; i < n; ++i) {
            val = rand.nextGaussian();
            sketchA.update((long)i, new double[]{val});
            a[i] = val;
        }
        for (i = 0; i < n; ++i) {
            val = rand.nextGaussian() + (double)bShift;
            sketchB.update((long)i, new double[]{val});
            b[i] = val;
        }
        TTest tTest = new TTest();
        double expectedPValue = tTest.tTest(a, b);
        Tuple inputTuple = PigUtil.objectsToTuple(new DataByteArray(sketchA.compact().toByteArray()), new DataByteArray(sketchB.compact().toByteArray()));
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        Assert.assertEquals((double)((Double)resultTuple.get(0)), (double)expectedPValue, (double)0.01);
    }

    @Test
    public void twoMetrics() throws IOException {
        int i;
        ArrayOfDoublesSketchesToPValueEstimates func = new ArrayOfDoublesSketchesToPValueEstimates();
        ArrayOfDoublesUpdatableSketch sketchA = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(2).setNominalEntries(128).build();
        ArrayOfDoublesUpdatableSketch sketchB = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(2).setNominalEntries(128).build();
        double[] groupA = new double[]{7.3, 6.5, 5.2, 6.3, 7.0, 5.9, 5.2, 5.0, 4.7, 5.7, 5.7, 3.3, 5.0, 4.6, 4.8, 3.8, 4.6};
        double[] groupB = new double[]{4.2, 4.0, 2.6, 4.9, 4.4, 4.4, 5.5, 5.1, 5.1, 3.2, 3.9, 3.2, 4.9, 4.3, 4.8, 2.4, 5.5, 5.5, 3.7};
        for (i = 0; i < groupA.length; ++i) {
            sketchA.update((long)i, new double[]{groupA[i], i});
        }
        for (i = 0; i < groupB.length; ++i) {
            sketchB.update((long)i, new double[]{groupB[i], i});
        }
        Tuple inputTuple = PigUtil.objectsToTuple(new DataByteArray(sketchA.compact().toByteArray()), new DataByteArray(sketchB.compact().toByteArray()));
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)2);
        Assert.assertEquals((double)((Double)resultTuple.get(0)), (double)0.0043, (double)1.0E-4);
        Assert.assertEquals((double)((Double)resultTuple.get(1)), (double)0.58, (double)0.01);
    }

    @Test
    public void sketchWithSingleValue() throws IOException {
        int i;
        ArrayOfDoublesSketchesToPValueEstimates func = new ArrayOfDoublesSketchesToPValueEstimates();
        ArrayOfDoublesUpdatableSketch sketchA = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(1).setNominalEntries(128).build();
        ArrayOfDoublesUpdatableSketch sketchB = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(1).setNominalEntries(128).build();
        double[] groupA = new double[]{7.3, 6.5, 5.2, 6.3, 7.0, 5.9, 5.2, 5.0, 4.7, 5.7, 5.7, 3.3, 5.0, 4.6, 4.8, 3.8, 4.6};
        double[] groupB = new double[]{5.0};
        for (i = 0; i < groupA.length; ++i) {
            sketchA.update((long)i, new double[]{groupA[i]});
        }
        for (i = 0; i < groupB.length; ++i) {
            sketchB.update((long)i, new double[]{groupB[i]});
        }
        Tuple inputTuple = PigUtil.objectsToTuple(new DataByteArray(sketchA.compact().toByteArray()), new DataByteArray(sketchB.compact().toByteArray()));
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNull((Object)resultTuple);
    }
}

