/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.tuple.DataToDoubleSummarySketch;
import org.apache.datasketches.pig.tuple.PigUtil;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SketchIterator;
import org.apache.datasketches.tuple.Sketches;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.UpdatableSketch;
import org.apache.datasketches.tuple.UpdatableSketchBuilder;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryDeserializer;
import org.apache.datasketches.tuple.adouble.DoubleSummaryFactory;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DataToDoubleSummarySketchTest {
    @Test
    public void execNullInputTuple() throws Exception {
        DataToDoubleSummarySketch func = new DataToDoubleSummarySketch();
        Tuple resultTuple = (Tuple)func.exec(null);
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void execEmptyInputTuple() throws Exception {
        DataToDoubleSummarySketch func = new DataToDoubleSummarySketch();
        Tuple resultTuple = (Tuple)func.exec(TupleFactory.getInstance().newTuple());
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void execEmptyBag() throws Exception {
        DataToDoubleSummarySketch func = new DataToDoubleSummarySketch();
        Tuple inputTuple = PigUtil.objectsToTuple(BagFactory.getInstance().newDefaultBag());
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Sketch sketch = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void execWrongSizeOfInnerTuple() throws Exception {
        DataToDoubleSummarySketch func = new DataToDoubleSummarySketch();
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(PigUtil.objectsToTuple(1));
        Tuple inputTuple = PigUtil.objectsToTuple(bag);
        func.exec(inputTuple);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void execWrongKeyType() throws Exception {
        DataToDoubleSummarySketch func = new DataToDoubleSummarySketch();
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(PigUtil.objectsToTuple(new Object(), 1.0));
        Tuple inputTuple = PigUtil.objectsToTuple(bag);
        func.exec(inputTuple);
    }

    @Test
    public void execAllInputTypes() throws Exception {
        DataToDoubleSummarySketch func = new DataToDoubleSummarySketch();
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(PigUtil.objectsToTuple("a", 1.0));
        bag.add(PigUtil.objectsToTuple("b", 1.0));
        bag.add(PigUtil.objectsToTuple("a", 2.0));
        bag.add(PigUtil.objectsToTuple("b", 2.0));
        bag.add(PigUtil.objectsToTuple(1, 3.0));
        bag.add(PigUtil.objectsToTuple(2L, 3.0));
        bag.add(PigUtil.objectsToTuple(Float.valueOf(1.0f), 3.0));
        bag.add(PigUtil.objectsToTuple(2.0, 3.0));
        bag.add(PigUtil.objectsToTuple((byte)3, 3.0));
        bag.add(PigUtil.objectsToTuple(new DataByteArray("c".getBytes()), 3.0));
        Tuple inputTuple = PigUtil.objectsToTuple(bag);
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Sketch sketch = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertEquals((double)sketch.getEstimate(), (double)8.0, (double)0.0);
        SketchIterator it = sketch.iterator();
        while (it.next()) {
            Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)3.0);
        }
    }

    @Test
    public void execMinMode() throws Exception {
        DataToDoubleSummarySketch func = new DataToDoubleSummarySketch("32", "Min");
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(PigUtil.objectsToTuple("a", 1.0));
        bag.add(PigUtil.objectsToTuple("b", 2.0));
        bag.add(PigUtil.objectsToTuple("a", 2.0));
        bag.add(PigUtil.objectsToTuple("b", 1.0));
        Tuple inputTuple = PigUtil.objectsToTuple(bag);
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Sketch sketch = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertEquals((double)sketch.getEstimate(), (double)2.0, (double)0.0);
        SketchIterator it = sketch.iterator();
        while (it.next()) {
            Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)1.0);
        }
    }

    @Test
    public void accumulator() throws Exception {
        DataToDoubleSummarySketch func = new DataToDoubleSummarySketch("32");
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(PigUtil.objectsToTuple("a", 1.0));
        inputTuple.set(0, (Object)bag);
        func.accumulate(inputTuple);
        inputTuple = TupleFactory.getInstance().newTuple(1);
        bag = BagFactory.getInstance().newDefaultBag();
        bag.add(PigUtil.objectsToTuple("b", 1.0));
        bag.add(PigUtil.objectsToTuple("a", 2.0));
        bag.add(PigUtil.objectsToTuple("b", 2.0));
        inputTuple.set(0, (Object)bag);
        func.accumulate(inputTuple);
        Tuple resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Sketch sketch = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertEquals((double)sketch.getEstimate(), (double)2.0, (double)0.0);
        SketchIterator it = sketch.iterator();
        while (it.next()) {
            Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)3.0);
        }
        func.cleanup();
        resultTuple = (Tuple)func.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Sketch sketch2 = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertEquals((double)sketch2.getEstimate(), (double)0.0, (double)0.0);
    }

    @Test
    public void algebraicInitialOneParam() throws Exception {
        DataToDoubleSummarySketch.Initial func = new DataToDoubleSummarySketch.Initial(null);
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(PigUtil.objectsToTuple(null, null));
        bag.add(PigUtil.objectsToTuple(null, null));
        bag.add(PigUtil.objectsToTuple(null, null));
        inputTuple.set(0, (Object)bag);
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataBag resultBag = (DataBag)resultTuple.get(0);
        Assert.assertEquals((long)resultBag.size(), (long)3L);
    }

    @Test
    public void algebraicInitialTwoParams() throws Exception {
        DataToDoubleSummarySketch.Initial func = new DataToDoubleSummarySketch.Initial(null, null);
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        bag.add(PigUtil.objectsToTuple(null, null));
        bag.add(PigUtil.objectsToTuple(null, null));
        bag.add(PigUtil.objectsToTuple(null, null));
        inputTuple.set(0, (Object)bag);
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataBag resultBag = (DataBag)resultTuple.get(0);
        Assert.assertEquals((long)resultBag.size(), (long)3L);
    }

    @Test
    public void algebraicIntermediateFinal() throws Exception {
        DataToDoubleSummarySketch.IntermediateFinal func = new DataToDoubleSummarySketch.IntermediateFinal("32");
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        bag.add(PigUtil.objectsToTuple(PigUtil.tuplesToBag(PigUtil.objectsToTuple("a", 1.0))));
        UpdatableSketch ts = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
        ts.update("b", (Object)1.0);
        ts.update("a", (Object)2.0);
        ts.update("b", (Object)2.0);
        CompactSketch cs = ts.compact();
        bag.add(PigUtil.objectsToTuple(new DataByteArray(cs.toByteArray())));
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Sketch sketch = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertEquals((double)sketch.getEstimate(), (double)2.0, (double)0.0);
        SketchIterator it = sketch.iterator();
        while (it.next()) {
            Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)3.0);
        }
    }

    @Test
    public void algebraicIntermediateFinalMaxMode() throws Exception {
        DataToDoubleSummarySketch.IntermediateFinal func = new DataToDoubleSummarySketch.IntermediateFinal("32", "Max");
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        bag.add(PigUtil.objectsToTuple(PigUtil.tuplesToBag(PigUtil.objectsToTuple("a", 1.0))));
        bag.add(PigUtil.objectsToTuple(PigUtil.tuplesToBag(PigUtil.objectsToTuple("b", 1.0))));
        bag.add(PigUtil.objectsToTuple(PigUtil.tuplesToBag(PigUtil.objectsToTuple("a", 2.0))));
        bag.add(PigUtil.objectsToTuple(PigUtil.tuplesToBag(PigUtil.objectsToTuple("b", 2.0))));
        Tuple resultTuple = (Tuple)func.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Sketch sketch = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes.get()), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertEquals((double)sketch.getEstimate(), (double)2.0, (double)0.0);
        SketchIterator it = sketch.iterator();
        while (it.next()) {
            Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)2.0);
        }
    }
}

