/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.frequencies;

import java.io.IOException;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.pig.frequencies.Util;
import org.apache.log4j.Logger;
import org.apache.pig.Accumulator;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;

public abstract class UnionFrequentItemsSketch<T>
extends EvalFunc<Tuple>
implements Accumulator<Tuple> {
    private final int sketchSize_;
    private final ArrayOfItemsSerDe<T> serDe_;
    private ItemsSketch<T> sketch_;
    private boolean isFirstCall_ = true;

    public UnionFrequentItemsSketch(int sketchSize, ArrayOfItemsSerDe<T> serDe) {
        this.sketchSize_ = sketchSize;
        this.serDe_ = serDe;
    }

    public Tuple exec(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"exec is used");
            this.isFirstCall_ = false;
        }
        if (inputTuple == null || inputTuple.size() == 0) {
            return null;
        }
        this.accumulate(inputTuple);
        Tuple outputTuple = this.getValue();
        this.cleanup();
        return outputTuple;
    }

    public void accumulate(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"accumulator is used");
            this.isFirstCall_ = false;
        }
        if (inputTuple == null || inputTuple.size() != 1) {
            return;
        }
        Object obj = inputTuple.get(0);
        if (!(obj instanceof DataBag)) {
            return;
        }
        DataBag bag = (DataBag)inputTuple.get(0);
        if (bag.size() == 0L) {
            return;
        }
        if (this.sketch_ == null) {
            this.sketch_ = new ItemsSketch(this.sketchSize_);
        }
        for (Tuple innerTuple : bag) {
            int sz = innerTuple.size();
            if (sz != 1 || innerTuple.get(0) == null) continue;
            ItemsSketch<T> incomingSketch = Util.deserializeSketchFromTuple(innerTuple, this.serDe_);
            this.sketch_.merge(incomingSketch);
        }
    }

    public Tuple getValue() {
        if (this.sketch_ == null) {
            try {
                return Util.serializeSketchToTuple(new ItemsSketch(this.sketchSize_), this.serDe_);
            }
            catch (ExecException ex) {
                throw new RuntimeException("Pig Error: " + ex.getMessage(), ex);
            }
        }
        try {
            return Util.serializeSketchToTuple(this.sketch_, this.serDe_);
        }
        catch (ExecException ex) {
            throw new RuntimeException("Pig Error: " + ex.getMessage(), ex);
        }
    }

    public void cleanup() {
        if (this.sketch_ != null) {
            this.sketch_.reset();
        }
    }
}

