/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.response.add;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.model.message.AddResponse;
import org.apache.directory.api.ldap.model.message.AddResponseImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitAddResponse
extends GrammarAction<LdapMessageContainer<AddResponse>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitAddResponse.class);

    public InitAddResponse() {
        super("Init AddResponse");
    }

    @Override
    public void action(LdapMessageContainer<AddResponse> container) throws DecoderException {
        AddResponseImpl addResponse = new AddResponseImpl(container.getMessageId());
        container.setMessage(addResponse);
        TLV tlv = container.getCurrentTLV();
        int expectedLength = tlv.getLength();
        if (expectedLength == 0) {
            String msg = I18n.err(I18n.ERR_05146_NULL_ADD_RESPONSE, new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05167_ADD_RESPONSE, new Object[0]));
        }
    }
}

