/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.dubbo.common.serialize.protostuff.delegate;

import io.protostuff.Input;
import io.protostuff.Output;
import io.protostuff.Pipe;
import io.protostuff.WireFormat;
import io.protostuff.runtime.Delegate;

import java.io.IOException;

import org.apache.dubbo.common.url.component.ServiceConfigURL;

/**
 * Custom {@link org.apache.dubbo.common.url.component.ServiceConfigURL} delegate
 */
public class ServiceConfigURLDelegate implements Delegate<ServiceConfigURL> {
    @Override
    public WireFormat.FieldType getFieldType() {
        return WireFormat.FieldType.STRING;
    }

    @Override
    public ServiceConfigURL readFrom(Input input) throws IOException {
        return (ServiceConfigURL) org.apache.dubbo.common.URL.valueOf(input.readString());
    }

    @Override
    public void writeTo(Output output, int number, ServiceConfigURL value, boolean repeated) throws IOException {
        output.writeString(number, value.toFullString(), repeated);
    }

    @Override
    public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
        output.writeString(number, input.readString(), repeated);
    }

    @Override
    public Class<?> typeClass() {
        return ServiceConfigURL.class;
    }
}
