/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.geronimo.arthur.knight.slf4j;

import org.apache.geronimo.arthur.spi.ArthurExtension;

public class Slf4jExtension implements ArthurExtension {
    @Override
    public void execute(final Context context) {
        // use strings cause maven uses slf4j and we don't want NoClassDefFoundError
        context.initializeAtBuildTime(
                "org.slf4j.impl.JDK14LoggerAdapter",
                "org.slf4j.impl.StaticLoggerBinder",
                "org.slf4j.LoggerFactory");
    }

    @Override
    public int order() {
        return 10;
    }
}
