/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.build.gradle;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.grails.forge.build.BuildPlugin;
import org.grails.forge.build.dependencies.Coordinate;
import org.grails.forge.build.dependencies.CoordinateResolver;
import org.grails.forge.build.dependencies.LookupFailedException;
import org.grails.forge.build.dependencies.Scope;
import org.grails.forge.options.BuildTool;
import org.grails.forge.template.Writable;

public class GradlePlugin
implements BuildPlugin {
    private final String id;
    private final String version;
    private final String artifactId;
    private final Writable extension;
    private final Writable settingsExtension;
    private final boolean requiresLookup;
    private final Set<String> buildImports;
    private final int order;
    private final boolean useApplyPlugin;

    public GradlePlugin(@NonNull String id, @Nullable String version, @Nullable String artifactId, @Nullable Writable extension, @Nullable Writable settingsExtension, boolean requiresLookup, int order, Set<String> buildImports) {
        this(id, version, artifactId, extension, settingsExtension, requiresLookup, order, buildImports, false);
    }

    public GradlePlugin(@NonNull String id, @Nullable String version, @Nullable String artifactId, @Nullable Writable extension, @Nullable Writable settingsExtension, boolean requiresLookup, int order, Set<String> buildImports, boolean useApplyPlugin) {
        this.id = id;
        this.version = version;
        this.artifactId = artifactId;
        this.extension = extension;
        this.settingsExtension = settingsExtension;
        this.requiresLookup = requiresLookup;
        this.order = order;
        this.buildImports = buildImports;
        this.useApplyPlugin = useApplyPlugin;
    }

    @Nullable
    public Set<String> getBuildImports() {
        return this.buildImports;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Override
    @NonNull
    public BuildTool getBuildTool() {
        return null;
    }

    @Override
    @Nullable
    public Writable getExtension() {
        return this.extension;
    }

    @Nullable
    public Writable getSettingsExtension() {
        return this.settingsExtension;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public boolean requiresLookup() {
        return this.requiresLookup;
    }

    public boolean useApplyPlugin() {
        return this.useApplyPlugin;
    }

    @Override
    public BuildPlugin resolved(CoordinateResolver coordinateResolver) {
        Coordinate coordinate = coordinateResolver.resolve(this.artifactId).orElseThrow(() -> new LookupFailedException(this.artifactId));
        return new GradlePlugin(this.id, coordinate.getVersion(), this.artifactId, this.extension, this.settingsExtension, false, this.order, this.buildImports);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GradlePlugin that = (GradlePlugin)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Scope scope = Scope.BUILD;
        private String id;
        private String artifactId;
        private String version;
        private Writable extension;
        private Writable settingsExtension;
        private boolean requiresLookup;
        private boolean pom = false;
        private int order = 0;
        private boolean useApplyPlugin = false;
        private boolean template = false;
        private Set<String> buildImports = new HashSet<String>();

        private Builder() {
        }

        @NonNull
        public Builder id(@NonNull String id) {
            this.id = id;
            return this;
        }

        @NonNull
        public Builder buildImports(String ... imports) {
            this.buildImports.addAll(Arrays.asList(imports));
            return this;
        }

        @NonNull
        public Builder lookupArtifactId(@NonNull String artifactId) {
            if (this.template) {
                return this.copy().lookupArtifactId(artifactId);
            }
            this.artifactId = artifactId;
            this.requiresLookup = true;
            return this;
        }

        @NonNull
        public Builder version(@Nullable String version) {
            this.version = version;
            return this;
        }

        @NonNull
        public Builder extension(@Nullable Writable extension) {
            this.extension = extension;
            return this;
        }

        @NonNull
        public Builder settingsExtension(@Nullable Writable settingsExtension) {
            this.settingsExtension = settingsExtension;
            return this;
        }

        @NonNull
        public Builder order(int order) {
            this.order = order;
            return this;
        }

        public Builder template() {
            this.template = true;
            return this;
        }

        public Builder pom(boolean pom) {
            this.pom = pom;
            return this;
        }

        public Builder useApplyPlugin(boolean useApplyPlugin) {
            this.useApplyPlugin = useApplyPlugin;
            return this;
        }

        public GradlePlugin build() {
            return new GradlePlugin(this.id, this.version, this.artifactId, this.extension, this.settingsExtension, this.requiresLookup, this.order, this.buildImports, this.useApplyPlugin);
        }

        private Builder copy() {
            Builder builder = new Builder();
            if (this.requiresLookup) {
                builder.lookupArtifactId(this.artifactId);
            } else {
                builder.id(this.id);
                builder.version(this.version);
            }
            if (this.extension != null) {
                builder.extension(this.extension);
            }
            return builder.order(this.order).pom(this.pom);
        }
    }
}

