/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.options;

import io.micronaut.core.annotation.NonNull;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import org.grails.forge.defaults.IncludesDefaults;
import org.grails.forge.defaults.LanguageDefaults;
import org.grails.forge.feature.Feature;
import org.grails.forge.options.BuildTool;
import org.grails.forge.options.TestFramework;

public enum Language implements IncludesDefaults<LanguageDefaults>
{
    GROOVY("groovy", new LanguageDefaults(TestFramework.SPOCK, BuildTool.GRADLE));

    public static final Language DEFAULT_OPTION;
    private final String extension;
    private final LanguageDefaults defaults;

    private Language(String extension, LanguageDefaults defaults) {
        this.extension = extension;
        this.defaults = defaults;
    }

    public String getExtension() {
        return this.extension;
    }

    public static String[] extensions() {
        return (String[])Arrays.stream(Language.values()).map(Language::getExtension).toArray(String[]::new);
    }

    public static String[] srcDirs() {
        return (String[])Arrays.stream(Language.values()).map(Language::getSrcDir).toArray(String[]::new);
    }

    public static String[] testSrcDirs() {
        return (String[])Arrays.stream(Language.values()).map(Language::getTestSrcDir).toArray(String[]::new);
    }

    public String getSrcDir() {
        return "src/main/" + this.getName();
    }

    public String getTestSrcDir() {
        return "src/test/" + this.getName();
    }

    public String getIntegrationSrcDir() {
        return "src/integration-test/" + this.getName();
    }

    public String getSourcePath(String path) {
        return this.getSrcDir() + path + "." + this.getExtension();
    }

    public String getTestSourcePath(String path) {
        return this.getTestSrcDir() + path + "." + this.getExtension();
    }

    public static Language infer(Set<Feature> features) {
        return GROOVY;
    }

    public String toString() {
        return this.getName();
    }

    @NonNull
    public String getName() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public LanguageDefaults getDefaults() {
        return this.defaults;
    }

    static {
        DEFAULT_OPTION = GROOVY;
    }
}

