/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.async;

import java.io.IOException;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.entity.DiscardingEntityConsumer;
import org.apache.hc.core5.http.support.BasicRequestBuilder;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class AsyncHttpRequestRetryExec
implements AsyncExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncHttpRequestRetryExec.class);
    private final HttpRequestRetryStrategy retryStrategy;

    public AsyncHttpRequestRetryExec(HttpRequestRetryStrategy retryStrategy) {
        Args.notNull(retryStrategy, "retryStrategy");
        this.retryStrategy = retryStrategy;
    }

    private void internalExecute(final State state, final HttpRequest request, final AsyncEntityProducer entityProducer, final AsyncExecChain.Scope scope, final AsyncExecChain chain, final AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        final String exchangeId = scope.exchangeId;
        chain.proceed(BasicRequestBuilder.copy(request).build(), entityProducer, scope, new AsyncExecCallback(){

            @Override
            public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                HttpClientContext clientContext = scope.clientContext;
                if (entityProducer != null && !entityProducer.isRepeatable()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} cannot retry non-repeatable request", (Object)exchangeId);
                    }
                    return asyncExecCallback.handleResponse(response, entityDetails);
                }
                state.retrying = AsyncHttpRequestRetryExec.this.retryStrategy.retryRequest(response, scope.execCount.get(), clientContext);
                if (state.retrying) {
                    state.status = response.getCode();
                    state.delay = AsyncHttpRequestRetryExec.this.retryStrategy.getRetryInterval(response, scope.execCount.get(), clientContext);
                    return new DiscardingEntityConsumer();
                }
                return asyncExecCallback.handleResponse(response, entityDetails);
            }

            @Override
            public void handleInformationResponse(HttpResponse response) throws HttpException, IOException {
                asyncExecCallback.handleInformationResponse(response);
            }

            @Override
            public void completed() {
                if (state.retrying) {
                    TimeValue delay;
                    int execCount = scope.execCount.incrementAndGet();
                    if (entityProducer != null) {
                        entityProducer.releaseResources();
                    }
                    HttpHost target = scope.route.getTargetHost();
                    TimeValue timeValue = delay = TimeValue.isPositive(state.delay) ? state.delay : TimeValue.ZERO_MILLISECONDS;
                    if (LOG.isInfoEnabled()) {
                        LOG.info("{} {} responded with status {}; request will be automatically re-executed in {} (exec count {})", exchangeId, target, state.status, delay, execCount);
                    }
                    scope.scheduler.scheduleExecution(request, entityProducer, scope, (r, e, s, c) -> AsyncHttpRequestRetryExec.this.execute(r, e, s, chain, c), asyncExecCallback, delay);
                } else {
                    asyncExecCallback.completed();
                }
            }

            @Override
            public void failed(Exception cause) {
                if (cause instanceof IOException) {
                    HttpHost target = scope.route.getTargetHost();
                    HttpClientContext clientContext = scope.clientContext;
                    if (entityProducer != null && !entityProducer.isRepeatable()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} cannot retry non-repeatable request", (Object)exchangeId);
                        }
                    } else if (AsyncHttpRequestRetryExec.this.retryStrategy.retryRequest(request, (IOException)cause, scope.execCount.get(), clientContext)) {
                        TimeValue delay;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} {}", exchangeId, cause.getMessage(), cause);
                        }
                        scope.execRuntime.discardEndpoint();
                        if (entityProducer != null) {
                            entityProducer.releaseResources();
                        }
                        state.retrying = true;
                        int execCount = scope.execCount.incrementAndGet();
                        state.delay = AsyncHttpRequestRetryExec.this.retryStrategy.getRetryInterval(request, (IOException)cause, execCount - 1, clientContext);
                        TimeValue timeValue = delay = TimeValue.isPositive(state.delay) ? state.delay : TimeValue.ZERO_MILLISECONDS;
                        if (LOG.isInfoEnabled()) {
                            LOG.info("{} recoverable I/O exception ({}) caught when sending request to {};request will be automatically re-executed in {} (exec count {})", exchangeId, cause.getClass().getName(), target, delay, execCount);
                        }
                        scope.scheduler.scheduleExecution(request, entityProducer, scope, (r, e, s, c) -> AsyncHttpRequestRetryExec.this.execute(r, e, s, chain, c), asyncExecCallback, delay);
                        return;
                    }
                }
                asyncExecCallback.failed(cause);
            }
        });
    }

    @Override
    public void execute(HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        State state = new State();
        state.retrying = false;
        this.internalExecute(state, request, entityProducer, scope, chain, asyncExecCallback);
    }

    private static class State {
        volatile boolean retrying;
        volatile int status;
        volatile TimeValue delay;

        private State() {
        }
    }
}

