/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;
import org.apache.tools.ant.taskdefs.optional.junit.IgnoredTestResult;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTaskMirror;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitVersionHelper;
import org.apache.tools.ant.taskdefs.optional.junit.TestListenerWrapper;
import org.apache.tools.ant.types.Permissions;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;
import org.apache.tools.ant.util.TeeOutputStream;

public class JUnitTestRunner
implements TestListener,
JUnitTaskMirror.JUnitTestRunnerMirror {
    private static final String JUNIT_4_TEST_ADAPTER = "junit.framework.JUnit4TestAdapter";
    private static final String[] DEFAULT_TRACE_FILTERS = new String[]{"junit.framework.TestCase", "junit.framework.TestResult", "junit.framework.TestSuite", "junit.framework.Assert.", "junit.swingui.TestRunner", "junit.awtui.TestRunner", "junit.textui.TestRunner", "java.lang.reflect.Method.invoke(", "sun.reflect.", "org.apache.tools.ant.", "org.junit.", "junit.framework.JUnit4TestAdapter", " more"};
    private static boolean filtertrace = true;
    private static boolean multipleTests = false;
    private static String crashFile = null;
    private final Vector<JUnitTaskMirror.JUnitResultFormatterMirror> formatters = new Vector();
    private IgnoredTestResult res;
    private boolean showOutput = false;
    private boolean outputToFormatters = true;
    private Permissions perm = null;
    private boolean haltOnError = false;
    private boolean haltOnFailure = false;
    private int retCode = 0;
    private final JUnitTest junitTest;
    private PrintStream systemError;
    private PrintStream systemOut;
    private boolean forked = false;
    private final ClassLoader loader;
    private boolean logTestListenerEvents = false;
    private boolean junit4;
    private String[] methods = null;
    private PrintStream savedOut = null;
    private PrintStream savedErr = null;
    private static Vector<FormatterElement> fromCmdLine = new Vector();

    public JUnitTestRunner(JUnitTest test, boolean haltOnError, boolean filtertrace, boolean haltOnFailure) {
        this(test, haltOnError, filtertrace, haltOnFailure, false);
    }

    public JUnitTestRunner(JUnitTest test, boolean haltOnError, boolean filtertrace, boolean haltOnFailure, boolean showOutput) {
        this(test, haltOnError, filtertrace, haltOnFailure, showOutput, false);
    }

    public JUnitTestRunner(JUnitTest test, boolean haltOnError, boolean filtertrace, boolean haltOnFailure, boolean showOutput, boolean logTestListenerEvents) {
        this(test, null, haltOnError, filtertrace, haltOnFailure, showOutput, logTestListenerEvents, null);
    }

    public JUnitTestRunner(JUnitTest test, String[] methods, boolean haltOnError, boolean filtertrace, boolean haltOnFailure, boolean showOutput, boolean logTestListenerEvents) {
        this(test, methods, haltOnError, filtertrace, haltOnFailure, showOutput, logTestListenerEvents, null);
    }

    public JUnitTestRunner(JUnitTest test, boolean haltOnError, boolean filtertrace, boolean haltOnFailure, ClassLoader loader) {
        this(test, haltOnError, filtertrace, haltOnFailure, false, loader);
    }

    public JUnitTestRunner(JUnitTest test, boolean haltOnError, boolean filtertrace, boolean haltOnFailure, boolean showOutput, ClassLoader loader) {
        this(test, haltOnError, filtertrace, haltOnFailure, showOutput, false, loader);
    }

    public JUnitTestRunner(JUnitTest test, boolean haltOnError, boolean filtertrace, boolean haltOnFailure, boolean showOutput, boolean logTestListenerEvents, ClassLoader loader) {
        this(test, null, haltOnError, filtertrace, haltOnFailure, showOutput, logTestListenerEvents, loader);
    }

    public JUnitTestRunner(JUnitTest test, String[] methods, boolean haltOnError, boolean filtertrace, boolean haltOnFailure, boolean showOutput, boolean logTestListenerEvents, ClassLoader loader) {
        JUnitTestRunner.filtertrace = filtertrace;
        this.junitTest = test;
        this.haltOnError = haltOnError;
        this.haltOnFailure = haltOnFailure;
        this.showOutput = showOutput;
        this.logTestListenerEvents = logTestListenerEvents;
        this.methods = methods != null ? (String[])methods.clone() : null;
        this.loader = loader;
    }

    private PrintStream createEmptyStream() {
        return new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
            }
        });
    }

    private PrintStream createTeePrint(PrintStream ps1, PrintStream ps2) {
        return new PrintStream(new TeeOutputStream(ps1, ps2));
    }

    private void setupIOStreams(ByteArrayOutputStream o, ByteArrayOutputStream e) {
        this.systemOut = new PrintStream(o);
        this.systemError = new PrintStream(e);
        if (this.forked) {
            if (!this.outputToFormatters) {
                if (!this.showOutput) {
                    this.savedOut = System.out;
                    this.savedErr = System.err;
                    System.setOut(this.createEmptyStream());
                    System.setErr(this.createEmptyStream());
                }
            } else {
                this.savedOut = System.out;
                this.savedErr = System.err;
                if (!this.showOutput) {
                    System.setOut(this.systemOut);
                    System.setErr(this.systemError);
                } else {
                    System.setOut(this.createTeePrint(this.savedOut, this.systemOut));
                    System.setErr(this.createTeePrint(this.savedErr, this.systemError));
                }
                this.perm = null;
            }
        } else if (this.perm != null) {
            this.perm.setSecurityManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block57: {
            block55: {
                block56: {
                    block58: {
                        this.res = new IgnoredTestResult();
                        this.res.addListener(this.wrapListener(this));
                        for (JUnitTaskMirror.JUnitResultFormatterMirror f : this.formatters) {
                            this.res.addListener(this.wrapListener((TestListener)f));
                        }
                        errStrm = new ByteArrayOutputStream();
                        outStrm = new ByteArrayOutputStream();
                        this.setupIOStreams(outStrm, errStrm);
                        suite = null;
                        exception = null;
                        startTestSuiteSuccess = false;
                        testClass = this.loader == null ? Class.forName(this.junitTest.getName(), false, this.getClass().getClassLoader()) : Class.forName(this.junitTest.getName(), false, this.loader);
                        testMethodsSpecified = this.methods != null;
                        suiteMethod = null;
                        if (!testMethodsSpecified) {
                            try {
                                suiteMethod = testClass.getMethod("suite", new Class[0]);
                            }
                            catch (NoSuchMethodException var9_15) {
                                // empty catch block
                            }
                        }
                        if (suiteMethod == null) break block58;
                        suite = (Test)suiteMethod.invoke(null, new Object[0]);
                        ** GOTO lbl100
                    }
                    junit4TestAdapterClass = null;
                    junit4TestAdapterCacheClass = null;
                    useSingleMethodAdapter = false;
                    if (!TestCase.class.isAssignableFrom(testClass)) {
                        try {
                            Class.forName("java.lang.annotation.Annotation");
                            junit4TestAdapterCacheClass = Class.forName("org.apache.tools.ant.taskdefs.optional.junit.CustomJUnit4TestAdapterCache");
                            if (this.loader == null) {
                                junit4TestAdapterClass = Class.forName("junit.framework.JUnit4TestAdapter");
                                if (testMethodsSpecified) {
                                    junit4TestAdapterClass = Class.forName("org.apache.tools.ant.taskdefs.optional.junit.JUnit4TestMethodAdapter");
                                    useSingleMethodAdapter = true;
                                }
                            } else {
                                junit4TestAdapterClass = Class.forName("junit.framework.JUnit4TestAdapter", true, this.loader);
                                if (testMethodsSpecified) {
                                    junit4TestAdapterClass = Class.forName("org.apache.tools.ant.taskdefs.optional.junit.JUnit4TestMethodAdapter", true, this.loader);
                                    useSingleMethodAdapter = true;
                                }
                            }
                        }
                        catch (ClassNotFoundException var12_19) {
                            // empty catch block
                        }
                    }
                    v0 = this.junit4 = junit4TestAdapterClass != null;
                    if (!this.junitTest.isSkipNonTests() || JUnitTestRunner.containsTests(testClass, this.junit4)) break block55;
                    if (this.perm == null) break block56;
                    this.perm.restoreSecurityManager();
                }
                if (this.savedOut != null) {
                    System.setOut(this.savedOut);
                }
                if (this.savedErr != null) {
                    System.setErr(this.savedErr);
                }
                this.systemError.close();
                this.systemError = null;
                this.systemOut.close();
                this.systemOut = null;
                if (startTestSuiteSuccess) {
                    try {
                        out = new String(outStrm.toByteArray());
                    }
                    catch (OutOfMemoryError ex) {
                        out = "out of memory on output stream";
                    }
                    try {
                        err = new String(errStrm.toByteArray());
                    }
                    catch (OutOfMemoryError ex) {
                        err = "out of memory on error stream";
                    }
                    this.sendOutAndErr(out, err);
                }
                return;
            }
            try {
                try {
                    if (this.junit4) {
                        if (useSingleMethodAdapter) {
                            formalParams = new Class[]{Class.class, String[].class};
                            actualParams = new Object[]{testClass, this.methods};
                        } else {
                            formalParams = new Class[]{Class.class, Class.forName("junit.framework.JUnit4TestAdapterCache")};
                            actualParams = new Object[]{testClass, junit4TestAdapterCacheClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0])};
                        }
                        suite = junit4TestAdapterClass.asSubclass(Test.class).getConstructor(formalParams).newInstance(actualParams);
                    } else if (!testMethodsSpecified) {
                        suite = new TestSuite(testClass);
                    } else if (this.methods.length == 1) {
                        suite = TestSuite.createTest(testClass, (String)this.methods[0]);
                    } else {
                        testSuite = new TestSuite(testClass.getName());
                        for (String method : this.methods) {
                            testSuite.addTest(TestSuite.createTest(testClass, (String)method));
                        }
                        suite = testSuite;
                    }
                }
                catch (Throwable e) {
                    this.retCode = 2;
                    exception = e;
                }
lbl100:
                // 6 sources

                start = System.currentTimeMillis();
                this.fireStartTestSuite();
                startTestSuiteSuccess = true;
                if (exception != null) {
                    for (JUnitTaskMirror.JUnitResultFormatterMirror f : this.formatters) {
                        ((TestListener)f).addError(null, exception);
                    }
                    this.junitTest.setCounts(1L, 0L, 1L, 0L);
                    this.junitTest.setRunTime(0L);
                    break block57;
                }
                try {
                    this.logTestListenerEvent("tests to run: " + suite.countTestCases());
                    suite.run((TestResult)this.res);
                }
                finally {
                    if (this.junit4 || suite.getClass().getName().equals("junit.framework.JUnit4TestAdapter")) {
                        cnts = this.findJUnit4FailureErrorCount(this.res);
                        this.junitTest.setCounts((long)this.res.runCount() + this.res.ignoredCount(), cnts[0], cnts[1], this.res.ignoredCount() + this.res.skippedCount());
                    } else {
                        this.junitTest.setCounts((long)this.res.runCount() + this.res.ignoredCount(), this.res.failureCount(), this.res.errorCount(), this.res.ignoredCount() + this.res.skippedCount());
                    }
                    this.junitTest.setRunTime(System.currentTimeMillis() - start);
                }
            }
            catch (Throwable var19_31) {
                throw var19_31;
            }
            finally {
                if (this.perm != null) {
                    this.perm.restoreSecurityManager();
                }
                if (this.savedOut != null) {
                    System.setOut(this.savedOut);
                }
                if (this.savedErr != null) {
                    System.setErr(this.savedErr);
                }
                this.systemError.close();
                this.systemError = null;
                this.systemOut.close();
                this.systemOut = null;
                if (startTestSuiteSuccess) {
                    try {
                        out = new String(outStrm.toByteArray());
                    }
                    catch (OutOfMemoryError ex) {
                        out = "out of memory on output stream";
                    }
                    try {
                        err = new String(errStrm.toByteArray());
                    }
                    catch (OutOfMemoryError ex) {
                        err = "out of memory on error stream";
                    }
                    this.sendOutAndErr(out, err);
                }
            }
        }
        this.fireEndTestSuite();
        if (this.retCode != 0 || this.junitTest.errorCount() != 0L) {
            this.retCode = 2;
        } else if (this.junitTest.failureCount() != 0L) {
            this.retCode = 1;
        }
    }

    private static boolean containsTests(Class<?> testClass, boolean isJUnit4) {
        Class<Annotation> runWithAnnotation;
        Class<Annotation> suiteAnnotation;
        Class<Annotation> testAnnotation;
        block14: {
            testAnnotation = null;
            suiteAnnotation = null;
            runWithAnnotation = null;
            try {
                testAnnotation = Class.forName("org.junit.Test").asSubclass(Annotation.class);
            }
            catch (ClassNotFoundException e) {
                if (!isJUnit4) break block14;
                return false;
            }
        }
        try {
            suiteAnnotation = Class.forName("org.junit.Suite.SuiteClasses").asSubclass(Annotation.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            runWithAnnotation = Class.forName("org.junit.runner.RunWith").asSubclass(Annotation.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!isJUnit4 && !TestCase.class.isAssignableFrom(testClass)) {
            return false;
        }
        for (Class<?> clazz : testClass.getDeclaredClasses()) {
            if (!JUnitTestRunner.containsTests(clazz, isJUnit4) && !JUnitTestRunner.containsTests(clazz, !isJUnit4)) continue;
            return true;
        }
        if (Modifier.isAbstract(testClass.getModifiers()) || Modifier.isInterface(testClass.getModifiers())) {
            return false;
        }
        if (isJUnit4) {
            if (suiteAnnotation != null && testClass.getAnnotation(suiteAnnotation) != null) {
                return true;
            }
            if (runWithAnnotation != null && testClass.getAnnotation(runWithAnnotation) != null) {
                return true;
            }
        }
        for (GenericDeclaration genericDeclaration : testClass.getMethods()) {
            if (isJUnit4 ? ((Method)genericDeclaration).getAnnotation(testAnnotation) != null : ((Method)genericDeclaration).getName().startsWith("test") && ((Method)genericDeclaration).getParameterTypes().length == 0 && (Modifier.isProtected(((Method)genericDeclaration).getModifiers()) || Modifier.isPublic(((Method)genericDeclaration).getModifiers()))) {
                return true;
            }
            if (!"suite".equals(((Method)genericDeclaration).getName()) || ((Method)genericDeclaration).getParameterTypes().length != 0 || !Modifier.isProtected(((Method)genericDeclaration).getModifiers()) && !Modifier.isPublic(((Method)genericDeclaration).getModifiers()) || !Modifier.isStatic(((Method)genericDeclaration).getModifiers())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getRetCode() {
        return this.retCode;
    }

    public void startTest(Test t) {
        String testName = JUnitVersionHelper.getTestCaseName(t);
        this.logTestListenerEvent("startTest(" + testName + ")");
    }

    public void endTest(Test test) {
        String testName = JUnitVersionHelper.getTestCaseName(test);
        this.logTestListenerEvent("endTest(" + testName + ")");
    }

    private void logTestListenerEvent(String message) {
        if (this.logTestListenerEvents) {
            PrintStream out = this.savedOut != null ? this.savedOut : System.out;
            out.flush();
            StringTokenizer messageLines = new StringTokenizer(String.valueOf(message), "\r\n", false);
            while (messageLines.hasMoreTokens()) {
                out.println("junit.framework.TestListener: " + messageLines.nextToken());
            }
            out.flush();
        }
    }

    public void addFailure(Test test, Throwable t) {
        String testName = JUnitVersionHelper.getTestCaseName(test);
        this.logTestListenerEvent("addFailure(" + testName + ", " + t.getMessage() + ")");
        if (this.haltOnFailure) {
            this.res.stop();
        }
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.addFailure(test, (Throwable)t);
    }

    public void addError(Test test, Throwable t) {
        String testName = JUnitVersionHelper.getTestCaseName(test);
        this.logTestListenerEvent("addError(" + testName + ", " + t.getMessage() + ")");
        if (this.haltOnError) {
            this.res.stop();
        }
    }

    @Override
    public void setPermissions(Permissions permissions) {
        this.perm = permissions;
    }

    @Override
    public void handleOutput(String output) {
        if ((this.logTestListenerEvents || !output.startsWith("junit.framework.TestListener: ")) && this.systemOut != null) {
            this.systemOut.print(output);
        }
    }

    @Override
    public int handleInput(byte[] buffer, int offset, int length) throws IOException {
        return -1;
    }

    @Override
    public void handleErrorOutput(String output) {
        if (this.systemError != null) {
            this.systemError.print(output);
        }
    }

    @Override
    public void handleFlush(String output) {
        if (this.systemOut != null) {
            this.systemOut.print(output);
        }
    }

    @Override
    public void handleErrorFlush(String output) {
        if (this.systemError != null) {
            this.systemError.print(output);
        }
    }

    private void sendOutAndErr(String out, String err) {
        for (JUnitTaskMirror.JUnitResultFormatterMirror f : this.formatters) {
            JUnitResultFormatter formatter = (JUnitResultFormatter)f;
            formatter.setSystemOutput(out);
            formatter.setSystemError(err);
        }
    }

    private void fireStartTestSuite() {
        for (JUnitTaskMirror.JUnitResultFormatterMirror f : this.formatters) {
            ((JUnitResultFormatter)f).startTestSuite(this.junitTest);
        }
    }

    private void fireEndTestSuite() {
        for (JUnitTaskMirror.JUnitResultFormatterMirror f : this.formatters) {
            ((JUnitResultFormatter)f).endTestSuite(this.junitTest);
        }
    }

    public void addFormatter(JUnitResultFormatter f) {
        this.formatters.addElement(f);
    }

    @Override
    public void addFormatter(JUnitTaskMirror.JUnitResultFormatterMirror f) {
        this.formatters.addElement(f);
    }

    public static void main(String[] args) throws IOException {
        String[] methods = null;
        boolean haltError = false;
        boolean haltFail = false;
        boolean stackfilter = true;
        Properties props = new Properties();
        boolean showOut = false;
        boolean outputToFormat = true;
        boolean logFailedTests = true;
        boolean logTestListenerEvents = false;
        boolean skipNonTests = false;
        int antThreadID = 0;
        if (args.length == 0) {
            System.err.println("required argument TestClassName missing");
            System.exit(2);
        }
        if (args[0].startsWith("testsfile=")) {
            multipleTests = true;
            args[0] = args[0].substring("testsfile=".length());
        }
        for (String arg : args) {
            if (arg.startsWith("methods=")) {
                try {
                    String methodsList = arg.substring("methods=".length());
                    methods = JUnitTest.parseTestMethodNamesList(methodsList);
                }
                catch (IllegalArgumentException ex) {
                    System.err.println("Invalid specification of test method names: " + arg);
                    System.exit(2);
                }
                continue;
            }
            if (arg.startsWith("haltOnError=")) {
                haltError = Project.toBoolean(arg.substring("haltOnError=".length()));
                continue;
            }
            if (arg.startsWith("haltOnFailure=")) {
                haltFail = Project.toBoolean(arg.substring("haltOnFailure=".length()));
                continue;
            }
            if (arg.startsWith("filtertrace=")) {
                stackfilter = Project.toBoolean(arg.substring("filtertrace=".length()));
                continue;
            }
            if (arg.startsWith("crashfile=")) {
                crashFile = arg.substring("crashfile=".length());
                JUnitTestRunner.registerTestCase("BeforeFirstTest");
                continue;
            }
            if (arg.startsWith("formatter=")) {
                try {
                    JUnitTestRunner.createAndStoreFormatter(arg.substring("formatter=".length()));
                }
                catch (BuildException be) {
                    System.err.println(be.getMessage());
                    System.exit(2);
                }
                continue;
            }
            if (arg.startsWith("propsfile=")) {
                InputStream in = Files.newInputStream(Paths.get(arg.substring("propsfile=".length()), new String[0]), new OpenOption[0]);
                props.load(in);
                in.close();
                continue;
            }
            if (arg.startsWith("showoutput=")) {
                showOut = Project.toBoolean(arg.substring("showoutput=".length()));
                continue;
            }
            if (arg.startsWith("logtestlistenerevents=")) {
                logTestListenerEvents = Project.toBoolean(arg.substring("logtestlistenerevents=".length()));
                continue;
            }
            if (arg.startsWith("outputtoformatters=")) {
                outputToFormat = Project.toBoolean(arg.substring("outputtoformatters=".length()));
                continue;
            }
            if (arg.startsWith("logfailedtests=")) {
                logFailedTests = Project.toBoolean(arg.substring("logfailedtests=".length()));
                continue;
            }
            if (arg.startsWith("skipNonTests=")) {
                skipNonTests = Project.toBoolean(arg.substring("skipNonTests=".length()));
                continue;
            }
            if (!arg.startsWith("threadid=")) continue;
            antThreadID = Integer.parseInt(arg.substring("threadid=".length()));
        }
        props.putAll((Map<?, ?>)System.getProperties());
        int returnCode = 0;
        if (multipleTests) {
            try (BufferedReader reader = new BufferedReader(new FileReader(args[0]));){
                int code = 0;
                boolean errorOccurred = false;
                boolean failureOccurred = false;
                String line = null;
                while ((line = reader.readLine()) != null) {
                    String[] testMethodNames;
                    String testCaseName;
                    StringTokenizer st = new StringTokenizer(line, ",");
                    String testListSpec = st.nextToken();
                    int colonIndex = testListSpec.indexOf(58);
                    if (colonIndex == -1) {
                        testCaseName = testListSpec;
                        testMethodNames = null;
                    } else {
                        testCaseName = testListSpec.substring(0, colonIndex);
                        testMethodNames = JUnitTest.parseTestMethodNamesList(testListSpec.substring(colonIndex + 1).replace('+', ','));
                    }
                    JUnitTest t = new JUnitTest(testCaseName);
                    t.setTodir(new File(st.nextToken()));
                    t.setOutfile(st.nextToken());
                    t.setProperties(props);
                    t.setSkipNonTests(skipNonTests);
                    t.setThread(antThreadID);
                    code = JUnitTestRunner.launch(t, testMethodNames, haltError, stackfilter, haltFail, showOut, outputToFormat, logTestListenerEvents);
                    errorOccurred = code == 2;
                    boolean bl = failureOccurred = code != 0;
                    if (!errorOccurred && !failureOccurred) continue;
                    if (errorOccurred && haltError || failureOccurred && haltFail) {
                        JUnitTestRunner.registerNonCrash();
                        System.exit(code);
                        continue;
                    }
                    if (code > returnCode) {
                        returnCode = code;
                    }
                    if (!logFailedTests) continue;
                    System.out.println("TEST " + t.getName() + " FAILED");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            JUnitTest t = new JUnitTest(args[0]);
            t.setThread(antThreadID);
            t.setProperties(props);
            t.setSkipNonTests(skipNonTests);
            returnCode = JUnitTestRunner.launch(t, methods, haltError, stackfilter, haltFail, showOut, outputToFormat, logTestListenerEvents);
        }
        JUnitTestRunner.registerNonCrash();
        System.exit(returnCode);
    }

    private static void transferFormatters(JUnitTestRunner runner, JUnitTest test) {
        runner.addFormatter(new JUnitResultFormatter(){

            @Override
            public void startTestSuite(JUnitTest suite) throws BuildException {
            }

            @Override
            public void endTestSuite(JUnitTest suite) throws BuildException {
            }

            @Override
            public void setOutput(OutputStream out) {
            }

            @Override
            public void setSystemOutput(String out) {
            }

            @Override
            public void setSystemError(String err) {
            }

            public void addError(Test arg0, Throwable arg1) {
            }

            public void addFailure(Test arg0, AssertionFailedError arg1) {
            }

            public void endTest(Test arg0) {
            }

            public void startTest(Test arg0) {
                JUnitTestRunner.registerTestCase(JUnitVersionHelper.getTestCaseName(arg0));
            }
        });
        for (FormatterElement fe : fromCmdLine) {
            if (multipleTests && fe.getUseFile()) {
                File destFile = new File(test.getTodir(), test.getOutfile() + fe.getExtension());
                fe.setOutfile(destFile);
            }
            runner.addFormatter((JUnitResultFormatter)fe.createFormatter());
        }
    }

    private static void createAndStoreFormatter(String line) throws BuildException {
        FormatterElement fe = new FormatterElement();
        int pos = line.indexOf(44);
        if (pos == -1) {
            fe.setClassname(line);
            fe.setUseFile(false);
        } else {
            fe.setClassname(line.substring(0, pos));
            fe.setUseFile(true);
            if (!multipleTests) {
                fe.setOutfile(new File(line.substring(pos + 1)));
            } else {
                int fName = line.indexOf("IGNORETHIS");
                if (fName > -1) {
                    fe.setExtension(line.substring(fName + "IGNORETHIS".length()));
                }
            }
        }
        fromCmdLine.addElement(fe);
    }

    public static String getFilteredTrace(Throwable t) {
        String trace = StringUtils.getStackTrace(t);
        return JUnitTestRunner.filterStack(trace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String filterStack(String stack) {
        if (!filtertrace) {
            return stack;
        }
        StringWriter sw = new StringWriter();
        BufferedWriter pw = new BufferedWriter(sw);
        StringReader sr = new StringReader(stack);
        BufferedReader br = new BufferedReader(sr);
        try {
            String line;
            boolean firstLine = true;
            while ((line = br.readLine()) != null) {
                if (firstLine || !JUnitTestRunner.filterLine(line)) {
                    pw.write(line);
                    pw.newLine();
                }
                firstLine = false;
            }
        }
        catch (Exception e) {
            String string = stack;
            return string;
        }
        finally {
            FileUtils.close(pw);
        }
        return sw.toString();
    }

    private static boolean filterLine(String line) {
        for (String filter2 : DEFAULT_TRACE_FILTERS) {
            if (!line.contains(filter2)) continue;
            return true;
        }
        return false;
    }

    private static int launch(JUnitTest t, String[] methods, boolean haltError, boolean stackfilter, boolean haltFail, boolean showOut, boolean outputToFormat, boolean logTestListenerEvents) {
        JUnitTestRunner runner = new JUnitTestRunner(t, methods, haltError, stackfilter, haltFail, showOut, logTestListenerEvents, null);
        runner.forked = true;
        runner.outputToFormatters = outputToFormat;
        JUnitTestRunner.transferFormatters(runner, t);
        runner.run();
        return runner.getRetCode();
    }

    private static void registerNonCrash() throws IOException {
        if (crashFile != null) {
            try (FileWriter out = new FileWriter(crashFile);){
                out.write("terminated successfully\n");
                out.flush();
            }
        }
    }

    private static void registerTestCase(String testCase) {
        if (crashFile != null) {
            try (FileWriter out = new FileWriter(crashFile);){
                out.write(testCase + "\n");
                out.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private TestListenerWrapper wrapListener(final TestListener testListener) {
        return new TestListenerWrapper(this, testListener){
            final /* synthetic */ JUnitTestRunner this$0;
            {
                this.this$0 = this$0;
                super(listener);
            }

            @Override
            public void addError(Test test, Throwable t) {
                if (this.this$0.junit4 && t instanceof AssertionFailedError) {
                    testListener.addFailure(test, (AssertionFailedError)t);
                } else if (this.this$0.junit4 && t instanceof AssertionError) {
                    String message = t.getMessage();
                    AssertionFailedError failure = message != null ? new AssertionFailedError(message) : new AssertionFailedError();
                    failure.initCause(t.getCause());
                    failure.setStackTrace(t.getStackTrace());
                    testListener.addFailure(test, failure);
                } else {
                    testListener.addError(test, t);
                }
            }

            @Override
            public void addFailure(Test test, AssertionFailedError t) {
                testListener.addFailure(test, t);
            }

            public void addFailure(Test test, Throwable t) {
                if (t instanceof AssertionFailedError) {
                    testListener.addFailure(test, (AssertionFailedError)t);
                } else {
                    testListener.addError(test, t);
                }
            }

            @Override
            public void endTest(Test test) {
                testListener.endTest(test);
            }

            @Override
            public void startTest(Test test) {
                testListener.startTest(test);
            }
        };
    }

    private int[] findJUnit4FailureErrorCount(TestResult result) {
        int failures = 0;
        int errors = 0;
        Enumeration e = result.failures();
        while (e.hasMoreElements()) {
            e.nextElement();
            ++failures;
        }
        e = result.errors();
        while (e.hasMoreElements()) {
            Throwable t = ((TestFailure)e.nextElement()).thrownException();
            if (t instanceof AssertionFailedError || t instanceof AssertionError) {
                ++failures;
                continue;
            }
            ++errors;
        }
        return new int[]{failures, errors};
    }
}

