/*
 * Decompiled with CFR 0.152.
 */
package org.grails.cli.gradle;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.Task;
import org.gradle.tooling.model.TaskSelector;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.gradle.tooling.model.gradle.BuildInvocations;

public class FetchAllTaskSelectorsBuildAction
implements BuildAction<AllTasksModel> {
    private static final long serialVersionUID = 1L;
    private final String currentProjectPath;

    public FetchAllTaskSelectorsBuildAction(File currentProjectDir) {
        this.currentProjectPath = currentProjectDir.getAbsolutePath();
    }

    @Override
    public AllTasksModel execute(BuildController controller2) {
        AllTasksModel model = new AllTasksModel();
        LinkedHashMap<String, Set<String>> allTaskSelectors = new LinkedHashMap<String, Set<String>>();
        model.allTaskSelectors = allTaskSelectors;
        LinkedHashMap<String, Set<String>> allTasks = new LinkedHashMap<String, Set<String>>();
        model.allTasks = allTasks;
        HashMap<String, String> projectPaths = new HashMap<String, String>();
        model.projectPaths = projectPaths;
        for (BasicGradleProject basicGradleProject : controller2.getBuildModel().getProjects()) {
            BuildInvocations entryPointsForProject = controller2.getModel(basicGradleProject, BuildInvocations.class);
            LinkedHashSet<String> selectorNames = new LinkedHashSet<String>();
            for (TaskSelector taskSelector : entryPointsForProject.getTaskSelectors()) {
                selectorNames.add(taskSelector.getName());
            }
            allTaskSelectors.put(basicGradleProject.getName(), selectorNames);
            LinkedHashSet<String> taskNames = new LinkedHashSet<String>();
            for (Task task : entryPointsForProject.getTasks()) {
                taskNames.add(task.getName());
            }
            allTasks.put(basicGradleProject.getName(), taskNames);
            projectPaths.put(basicGradleProject.getName(), basicGradleProject.getPath());
            if (!basicGradleProject.getProjectDirectory().getAbsolutePath().equals(this.currentProjectPath)) continue;
            model.currentProject = basicGradleProject.getName();
        }
        return model;
    }

    public static class AllTasksModel
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public Map<String, Set<String>> allTasks;
        public Map<String, Set<String>> allTaskSelectors;
        public Map<String, String> projectPaths;
        public String currentProject;
    }
}

