/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.template;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.grails.forge.io.OutputHandler;
import org.grails.forge.template.RenderResult;
import org.grails.forge.template.Template;
import org.grails.forge.template.TemplateRenderer;

public class DefaultTemplateRenderer
implements TemplateRenderer {
    private final Map<String, String> replacements;
    private final OutputHandler outputHandler;

    public DefaultTemplateRenderer(Map<String, String> pathReplacements, OutputHandler outputHandler) {
        this.replacements = pathReplacements;
        this.outputHandler = outputHandler;
    }

    @Override
    public RenderResult render(Template template, boolean force) {
        String path = this.replaceVariables(template.getPath(), this.replacements);
        if (this.outputHandler.exists(path) && !force) {
            return RenderResult.skipped(path);
        }
        try {
            this.outputHandler.write(path, template);
            return RenderResult.success(path);
        }
        catch (IOException e) {
            return RenderResult.error(path, e);
        }
    }

    protected String replaceVariables(String path, Map<String, String> replacements) {
        Pattern pattern = Pattern.compile("\\{(.+?)\\}");
        Matcher matcher = pattern.matcher(path);
        StringBuilder builder = new StringBuilder();
        int i2 = 0;
        while (matcher.find()) {
            String replacement = replacements.get(matcher.group(1));
            builder.append(path, i2, matcher.start());
            if (replacement == null) {
                builder.append(matcher.group(0));
            } else {
                builder.append(replacement);
            }
            i2 = matcher.end();
        }
        builder.append(path.substring(i2));
        return builder.toString();
    }

    @Override
    public void close() throws IOException {
        this.outputHandler.close();
    }
}

