/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.errors;

import grails.core.GrailsApplication;
import grails.util.GrailsStringUtils;
import jakarta.servlet.ServletContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Constructor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.grails.buffer.FastStringPrintWriter;
import org.grails.core.exceptions.GrailsException;
import org.grails.core.io.support.GrailsFactoriesLoader;
import org.grails.exceptions.reporting.SourceCodeAware;
import org.grails.gsp.ResourceAwareTemplateEngine;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.grails.web.util.GrailsApplicationAttributes;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class GrailsWrappedRuntimeException
extends GrailsException {
    private static final Class<? extends GrailsApplicationAttributes> grailsApplicationAttributesClass = GrailsFactoriesLoader.loadFactoryClasses(GrailsApplicationAttributes.class, GrailsWebRequest.class.getClassLoader()).get(0);
    private static final Constructor<? extends GrailsApplicationAttributes> grailsApplicationAttributesConstructor = ClassUtils.getConstructorIfAvailable(grailsApplicationAttributesClass, ServletContext.class);
    private static final long serialVersionUID = 7284065617154554366L;
    private static final Pattern ANY_GSP_DETAILS = Pattern.compile("_gsp.run");
    private static final Pattern PARSE_DETAILS_STEP1 = Pattern.compile("\\((\\w+)\\.groovy:(\\d+)\\)");
    private static final Pattern PARSE_DETAILS_STEP2 = Pattern.compile("at\\s{1}(\\w+)\\$_closure\\d+\\.doCall\\(\\1:(\\d+)\\)");
    private static final Pattern PARSE_GSP_DETAILS_STEP1 = Pattern.compile("_gsp\\.run\\(((\\w+?)_.*?):(\\d+)\\)");
    public static final String URL_PREFIX = "/WEB-INF/grails-app/";
    private static final Log LOG = LogFactory.getLog(GrailsWrappedRuntimeException.class);
    private String className;
    private int lineNumber;
    private String stackTrace;
    private String[] codeSnippet;
    private String gspFile;
    private Throwable cause;
    private PathMatchingResourcePatternResolver resolver;
    private String[] stackTraceLines;
    private static final String UNKNOWN = "Unknown";
    private String fileName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GrailsWrappedRuntimeException(ServletContext servletContext, Throwable t) {
        block46: {
            Throwable cause;
            super(t.getMessage(), t);
            this.className = UNKNOWN;
            this.lineNumber = -1;
            this.codeSnippet = new String[0];
            this.resolver = new PathMatchingResourcePatternResolver();
            this.cause = t;
            FastStringPrintWriter pw = FastStringPrintWriter.newInstance();
            cause.printStackTrace(pw);
            this.stackTrace = pw.toString();
            for (cause = t; cause.getCause() != cause && cause.getCause() != null; cause = cause.getCause()) {
            }
            this.stackTraceLines = this.stackTrace.split("\\n");
            if (cause instanceof MultipleCompilationErrorsException) {
                MultipleCompilationErrorsException mcee = (MultipleCompilationErrorsException)cause;
                Message message = mcee.getErrorCollector().getErrors().iterator().next();
                if (message instanceof SyntaxErrorMessage) {
                    SyntaxErrorMessage sem = (SyntaxErrorMessage)message;
                    this.lineNumber = sem.getCause().getLine();
                    this.className = sem.getCause().getSourceLocator();
                    sem.write(pw);
                }
            } else {
                Matcher m1 = PARSE_DETAILS_STEP1.matcher(this.stackTrace);
                Matcher m2 = PARSE_DETAILS_STEP2.matcher(this.stackTrace);
                Matcher gsp = PARSE_GSP_DETAILS_STEP1.matcher(this.stackTrace);
                try {
                    if (ANY_GSP_DETAILS.matcher(this.stackTrace).find() && gsp.find()) {
                        System.out.println(gsp.group(1) + " " + gsp.group(2) + " " + gsp.group(3));
                        this.className = gsp.group(1);
                        this.lineNumber = Integer.parseInt(gsp.group(3));
                        this.gspFile = "/WEB-INF/grails-app/views/" + gsp.group(2) + "/" + this.className;
                    } else if (m1.find()) {
                        do {
                            this.className = m1.group(1);
                            this.lineNumber = Integer.parseInt(m1.group(2));
                        } while (m1.find());
                    } else {
                        while (m2.find()) {
                            this.className = m2.group(1);
                            this.lineNumber = Integer.parseInt(m2.group(2));
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            BufferedReader reader = null;
            try {
                InputStream in;
                block47: {
                    Object fileLocation;
                    this.checkIfSourceCodeAware(t);
                    this.checkIfSourceCodeAware(cause);
                    if (this.getLineNumber() <= -1) break block46;
                    Object url = null;
                    if (this.fileName != null) {
                        fileLocation = this.fileName;
                    } else {
                        Object urlPrefix = "";
                        if (this.gspFile == null) {
                            this.fileName = this.className.replace('.', '/') + ".groovy";
                            GrailsApplication application2 = WebApplicationContextUtils.getRequiredWebApplicationContext(servletContext).getBean("grailsApplication", GrailsApplication.class);
                            if (application2.isArtefactOfType("Controller", this.className)) {
                                urlPrefix = (String)urlPrefix + "/controllers/";
                            } else if (application2.isArtefactOfType("TagLib", this.className)) {
                                urlPrefix = (String)urlPrefix + "/taglib/";
                            } else if (application2.isArtefactOfType("Service", this.className)) {
                                urlPrefix = (String)urlPrefix + "/services/";
                            }
                            url = URL_PREFIX + (String)urlPrefix + this.fileName;
                        } else {
                            url = this.gspFile;
                            GrailsApplicationAttributes attrs = null;
                            try {
                                attrs = grailsApplicationAttributesConstructor.newInstance(servletContext);
                            }
                            catch (Exception e) {
                                ReflectionUtils.rethrowRuntimeException(e);
                            }
                            ResourceAwareTemplateEngine engine = attrs.getPagesTemplateEngine();
                            this.lineNumber = engine.mapStackLineNumber((String)url, this.lineNumber);
                        }
                        fileLocation = "grails-app" + (String)urlPrefix + this.fileName;
                    }
                    in = null;
                    if (!GrailsStringUtils.isBlank(url)) {
                        in = servletContext.getResourceAsStream((String)url);
                        LOG.debug("Attempting to display code snippet found in url " + (String)url);
                    }
                    if (in == null) {
                        Resource r = null;
                        try {
                            r = this.resolver.getResource((String)fileLocation);
                            in = r.getInputStream();
                        }
                        catch (Throwable e) {
                            r = this.resolver.getResource("file:" + (String)fileLocation);
                            if (!r.exists()) break block47;
                            try {
                                in = r.getInputStream();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (in != null) {
                    reader = new LineNumberReader(new InputStreamReader(in, "UTF-8"));
                    String currentLine = ((LineNumberReader)reader).readLine();
                    StringBuilder buf = new StringBuilder();
                    while (currentLine != null) {
                        int currentLineNumber = ((LineNumberReader)reader).getLineNumber();
                        if (this.lineNumber > 0 && currentLineNumber == this.lineNumber - 1 || currentLineNumber == this.lineNumber) {
                            buf.append(currentLineNumber).append(": ").append(currentLine).append("\n");
                        } else if (currentLineNumber == this.lineNumber + 1) {
                            buf.append(currentLineNumber).append(": ").append(currentLine);
                            break;
                        }
                        currentLine = ((LineNumberReader)reader).readLine();
                    }
                    this.codeSnippet = buf.toString().split("\n");
                }
            }
            catch (IOException e) {
                LOG.warn("[GrailsWrappedRuntimeException] I/O error reading line diagnostics: " + e.getMessage(), e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void checkIfSourceCodeAware(Throwable t) {
        if (!(t instanceof SourceCodeAware)) {
            return;
        }
        SourceCodeAware codeAware = (SourceCodeAware)((Object)t);
        if (codeAware.getFileName() != null) {
            this.fileName = codeAware.getFileName();
            if (this.className == null || UNKNOWN.equals(this.className)) {
                this.className = codeAware.getFileName();
            }
        }
        if (codeAware.getLineNumber() > -1) {
            this.lineNumber = codeAware.getLineNumber();
        }
    }

    public String[] getCodeSnippet() {
        return this.codeSnippet;
    }

    public String getClassName() {
        return this.className;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getStackTraceText() {
        return this.stackTrace;
    }

    public String[] getStackTraceLines() {
        return this.stackTraceLines;
    }

    @Override
    public String getMessage() {
        return this.cause.getMessage();
    }
}

