/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.HelixProperty;
import org.apache.helix.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentState
extends HelixProperty {
    private static Logger LOG = LoggerFactory.getLogger(CurrentState.class);

    public CurrentState(String resourceName) {
        super(resourceName);
    }

    public CurrentState(ZNRecord record) {
        super(record);
    }

    public String getResourceName() {
        return this._record.getId();
    }

    public Map<String, String> getPartitionStateMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Map<String, Map<String, String>> mapFields = this._record.getMapFields();
        for (String partitionName : mapFields.keySet()) {
            Map<String, String> tempMap = mapFields.get(partitionName);
            if (tempMap == null) continue;
            map.put(partitionName, tempMap.get(CurrentStateProperty.CURRENT_STATE.name()));
        }
        return map;
    }

    public String getSessionId() {
        return this._record.getSimpleField(CurrentStateProperty.SESSION_ID.name());
    }

    public void setSessionId(String sessionId) {
        this._record.setSimpleField(CurrentStateProperty.SESSION_ID.name(), sessionId);
    }

    public String getState(String partitionName) {
        return this.getProperty(partitionName, CurrentStateProperty.CURRENT_STATE);
    }

    public String getInfo(String partitionName) {
        return this.getProperty(partitionName, CurrentStateProperty.INFO);
    }

    public String getRequestedState(String partitionName) {
        return this.getProperty(partitionName, CurrentStateProperty.REQUESTED_STATE);
    }

    public long getStartTime(String partitionName) {
        String startTime = this.getProperty(partitionName, CurrentStateProperty.START_TIME);
        return startTime == null ? -1L : Long.parseLong(startTime);
    }

    public long getEndTime(String partitionName) {
        String endTime = this.getProperty(partitionName, CurrentStateProperty.END_TIME);
        return endTime == null ? -1L : Long.parseLong(endTime);
    }

    public String getTriggerHost(String partitionName) {
        return this.getProperty(partitionName, CurrentStateProperty.TRIGGERED_BY);
    }

    public String getPreviousState(String partitionName) {
        return this.getProperty(partitionName, CurrentStateProperty.PREVIOUS_STATE);
    }

    private String getProperty(String partitionName, CurrentStateProperty property) {
        Map<String, String> mapField = this._record.getMapField(partitionName);
        if (mapField != null) {
            return mapField.get(property.name());
        }
        return null;
    }

    public void setStateModelDefRef(String stateModelName) {
        this._record.setSimpleField(CurrentStateProperty.STATE_MODEL_DEF.name(), stateModelName);
    }

    public String getStateModelDefRef() {
        return this._record.getSimpleField(CurrentStateProperty.STATE_MODEL_DEF.name());
    }

    public void setState(String partitionName, String state) {
        this.setProperty(partitionName, CurrentStateProperty.CURRENT_STATE, state);
    }

    public void setInfo(String partitionName, String info) {
        this.setProperty(partitionName, CurrentStateProperty.INFO, info);
    }

    public void setRequestedState(String partitionName, String state) {
        this.setProperty(partitionName, CurrentStateProperty.REQUESTED_STATE, state);
    }

    public void setStartTime(String partitionName, long startTime) {
        this.setProperty(partitionName, CurrentStateProperty.START_TIME, String.valueOf(startTime));
    }

    public void setEndTime(String partitionName, long endTime) {
        this.setProperty(partitionName, CurrentStateProperty.END_TIME, String.valueOf(endTime));
    }

    public void setTriggerHost(String partitionName, String triggerHost) {
        this.setProperty(partitionName, CurrentStateProperty.TRIGGERED_BY, triggerHost);
    }

    public void setPreviousState(String partitionName, String state) {
        this.setProperty(partitionName, CurrentStateProperty.PREVIOUS_STATE, state);
    }

    private void setProperty(String partitionName, CurrentStateProperty property, String value) {
        Map<String, Map<String, String>> mapFields = this._record.getMapFields();
        if (mapFields.get(partitionName) == null) {
            mapFields.put(partitionName, new TreeMap());
        }
        mapFields.get(partitionName).put(property.name(), value);
    }

    public void setStateModelFactoryName(String factoryName) {
        this._record.setSimpleField(CurrentStateProperty.STATE_MODEL_FACTORY_NAME.name(), factoryName);
    }

    public String getStateModelFactoryName() {
        return this._record.getSimpleField(CurrentStateProperty.STATE_MODEL_FACTORY_NAME.name());
    }

    @Override
    public boolean isValid() {
        if (this.getStateModelDefRef() == null) {
            LOG.error("Current state does not contain state model ref. id:" + this.getResourceName());
            return false;
        }
        if (this.getSessionId() == null) {
            LOG.error("CurrentState does not contain session id, id : " + this.getResourceName());
            return false;
        }
        return true;
    }

    public static enum CurrentStateProperty {
        SESSION_ID,
        CURRENT_STATE,
        REQUESTED_STATE,
        INFO,
        STATE_MODEL_DEF,
        STATE_MODEL_FACTORY_NAME,
        RESOURCE,
        START_TIME,
        END_TIME,
        PREVIOUS_STATE,
        TRIGGERED_BY;

    }
}

