/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.helix.HelixException;
import org.apache.helix.ZNRecord;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.rebalancer.strategy.RebalanceStrategy;
import org.apache.helix.controller.rebalancer.strategy.crushMapping.CardDealingAdjustmentAlgorithmV2;
import org.apache.helix.controller.rebalancer.strategy.crushMapping.ConsistentHashingAdjustmentAlgorithm;
import org.apache.helix.controller.rebalancer.topology.InstanceNode;
import org.apache.helix.controller.rebalancer.topology.Node;
import org.apache.helix.controller.rebalancer.topology.Topology;
import org.apache.helix.model.InstanceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEvenDistributionRebalanceStrategy
implements RebalanceStrategy<ResourceControllerDataProvider> {
    private static final Logger _logger = LoggerFactory.getLogger(AbstractEvenDistributionRebalanceStrategy.class);
    protected String _resourceName;
    protected int _replica;

    protected abstract RebalanceStrategy<ResourceControllerDataProvider> getBaseRebalanceStrategy();

    protected CardDealingAdjustmentAlgorithmV2 getCardDealingAlgorithm(Topology topology) {
        return new CardDealingAdjustmentAlgorithmV2(topology, this._replica, CardDealingAdjustmentAlgorithmV2.Mode.MINIMIZE_MOVEMENT);
    }

    @Override
    public void init(String resourceName, List<String> partitions, LinkedHashMap<String, Integer> states, int maximumPerNode) {
        this._resourceName = resourceName;
        this.getBaseRebalanceStrategy().init(resourceName, partitions, states, maximumPerNode);
        this._replica = this.countStateReplicas(states);
    }

    @Override
    public ZNRecord computePartitionAssignment(List<String> allNodes, List<String> liveNodes, Map<String, Map<String, String>> currentMapping, ResourceControllerDataProvider clusterData) {
        Map<String, InstanceConfig> instanceConfigMap = clusterData.getInstanceConfigMap();
        if (instanceConfigMap == null || !instanceConfigMap.keySet().containsAll(allNodes)) {
            throw new HelixException(String.format("Config for instances %s is not found!", allNodes.removeAll(instanceConfigMap.keySet())));
        }
        return this.computeBestPartitionAssignment(this.getNonZeroWeightNodes(allNodes, instanceConfigMap), liveNodes, currentMapping, clusterData);
    }

    private List<String> getNonZeroWeightNodes(List<String> nodes, Map<String, InstanceConfig> instanceConfigMap) {
        return nodes.stream().filter(node -> ((InstanceConfig)instanceConfigMap.get(node)).getWeight() != 0).collect(Collectors.toList());
    }

    private ZNRecord computeBestPartitionAssignment(List<String> allNodes, List<String> liveNodes, Map<String, Map<String, String>> currentMapping, ResourceControllerDataProvider clusterData) {
        ZNRecord origAssignment = this.getBaseRebalanceStrategy().computePartitionAssignment(allNodes, allNodes, currentMapping, clusterData);
        Map<String, List<String>> origPartitionMap = origAssignment.getListFields();
        String eventId = clusterData.getClusterEventId();
        if (!origPartitionMap.isEmpty()) {
            Map<String, List<Node>> finalPartitionMap = null;
            Topology allNodeTopo = new Topology(allNodes, allNodes, clusterData.getInstanceConfigMap(), clusterData.getClusterConfig());
            Map<Node, List<String>> nodeToPartitionMap = this.convertPartitionMap(origPartitionMap, allNodeTopo);
            CardDealingAdjustmentAlgorithmV2 cardDealer = this.getCardDealingAlgorithm(allNodeTopo);
            if (cardDealer.computeMapping(nodeToPartitionMap, this._resourceName.hashCode())) {
                finalPartitionMap = this.shufflePreferenceList(nodeToPartitionMap);
                if (!liveNodes.containsAll(allNodes)) {
                    try {
                        ConsistentHashingAdjustmentAlgorithm hashPlacement = new ConsistentHashingAdjustmentAlgorithm(allNodeTopo, liveNodes);
                        if (hashPlacement.computeMapping(nodeToPartitionMap, this._resourceName.hashCode())) {
                            Map<String, List<Node>> adjustedPartitionMap = this.convertAssignment(nodeToPartitionMap);
                            for (String partition : adjustedPartitionMap.keySet()) {
                                List<Node> preSelectedList = finalPartitionMap.get(partition);
                                HashSet adjustedNodeList = new HashSet(adjustedPartitionMap.get(partition));
                                List<Node> finalNodeList = adjustedPartitionMap.get(partition);
                                int index = 0;
                                for (Node node : preSelectedList) {
                                    if (!adjustedNodeList.remove(node)) continue;
                                    finalNodeList.set(index++, node);
                                }
                                for (Node node : adjustedNodeList) {
                                    finalNodeList.set(index++, node);
                                }
                            }
                            finalPartitionMap = adjustedPartitionMap;
                        } else {
                            finalPartitionMap = null;
                        }
                    }
                    catch (ExecutionException e) {
                        LogUtil.logError(_logger, eventId, "Failed to perform consistent hashing partition assigner.", e);
                        finalPartitionMap = null;
                    }
                }
            }
            if (null != finalPartitionMap) {
                ZNRecord result = new ZNRecord(this._resourceName);
                HashMap<String, List<String>> resultPartitionMap = new HashMap<String, List<String>>();
                for (String partitionName : finalPartitionMap.keySet()) {
                    ArrayList<String> instanceNames = new ArrayList<String>();
                    for (Node node : finalPartitionMap.get(partitionName)) {
                        if (node instanceof InstanceNode) {
                            instanceNames.add(((InstanceNode)node).getInstanceName());
                            continue;
                        }
                        LogUtil.logError(_logger, eventId, String.format("Selected node is not associated with an instance: %s", node));
                    }
                    resultPartitionMap.put(partitionName, instanceNames);
                }
                result.setListFields(resultPartitionMap);
                return result;
            }
        }
        if (_logger.isDebugEnabled()) {
            LogUtil.logDebug(_logger, eventId, "Force even distribution is not possible, using the default strategy: " + this.getBaseRebalanceStrategy().getClass().getSimpleName());
        }
        if (liveNodes.equals(allNodes)) {
            return origAssignment;
        }
        return this.getBaseRebalanceStrategy().computePartitionAssignment(allNodes, liveNodes, currentMapping, clusterData);
    }

    private Map<String, List<Node>> shufflePreferenceList(Map<Node, List<String>> nodeToPartitionMap) {
        Map<String, List<Node>> partitionMap = this.convertAssignment(nodeToPartitionMap);
        final HashMap<Node, Integer> nodeScores = new HashMap<Node, Integer>();
        for (Node node : nodeToPartitionMap.keySet()) {
            nodeScores.put(node, nodeToPartitionMap.get(node).size());
        }
        for (final String partition : partitionMap.keySet()) {
            List<Node> nodes = partitionMap.get(partition);
            Collections.sort(nodes, new Comparator<Node>(){

                @Override
                public int compare(Node o1, Node o2) {
                    int o2Score;
                    int o1Score = (Integer)nodeScores.get(o1);
                    if (o1Score == (o2Score = ((Integer)nodeScores.get(o2)).intValue())) {
                        return new Integer((partition + o1.getName()).hashCode()).compareTo((partition + o2.getName()).hashCode());
                    }
                    return o1Score - o2Score;
                }
            });
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = nodes.get(i);
                nodeScores.put(node, (Integer)nodeScores.get(node) - 1 + (i == 0 ? (int)Math.pow(this._replica, 2.0) : 0));
            }
        }
        return partitionMap;
    }

    private Map<String, List<Node>> convertAssignment(Map<Node, List<String>> assignment) {
        HashMap<String, List<Node>> resultMap = new HashMap<String, List<Node>>();
        for (Node instance : assignment.keySet()) {
            for (String partitionName : assignment.get(instance)) {
                if (!resultMap.containsKey(partitionName)) {
                    resultMap.put(partitionName, new ArrayList());
                }
                ((List)resultMap.get(partitionName)).add(instance);
            }
        }
        return resultMap;
    }

    private Map<Node, List<String>> convertPartitionMap(Map<String, List<String>> originalMap, Topology topology) {
        HashMap<Node, List<String>> resultMap = new HashMap<Node, List<String>>();
        HashMap<String, InstanceNode> instanceMap = new HashMap<String, InstanceNode>();
        for (Node node : Topology.getAllLeafNodes(topology.getRootNode())) {
            if (!(node instanceof InstanceNode)) continue;
            InstanceNode insNode = (InstanceNode)node;
            instanceMap.put(insNode.getInstanceName(), insNode);
        }
        for (String partition : originalMap.keySet()) {
            for (String instanceName : originalMap.get(partition)) {
                Node insNode = (Node)instanceMap.get(instanceName);
                if (insNode == null) continue;
                if (!resultMap.containsKey(insNode)) {
                    resultMap.put(insNode, new ArrayList());
                }
                ((List)resultMap.get(insNode)).add(partition);
            }
        }
        return resultMap;
    }

    private int countStateReplicas(Map<String, Integer> stateCountMap) {
        int total = 0;
        for (Integer count : stateCountMap.values()) {
            total += count.intValue();
        }
        return total;
    }
}

