/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk.client;

import java.util.HashMap;
import org.apache.helix.HelixException;
import org.apache.helix.manager.zk.client.HelixZkClient;
import org.apache.helix.manager.zk.client.HelixZkClientFactory;
import org.apache.helix.manager.zk.client.SharedZkClient;
import org.apache.helix.manager.zk.client.ZkConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedZkClientFactory
extends HelixZkClientFactory {
    private static Logger LOG = LoggerFactory.getLogger(SharedZkClient.class);
    private final HashMap<HelixZkClient.ZkConnectionConfig, ZkConnectionManager> _connectionManagerPool = new HashMap();

    protected SharedZkClientFactory() {
    }

    public static SharedZkClientFactory getInstance() {
        return SingletonHelper.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HelixZkClient buildZkClient(HelixZkClient.ZkConnectionConfig connectionConfig, HelixZkClient.ZkClientConfig clientConfig) {
        HashMap<HelixZkClient.ZkConnectionConfig, ZkConnectionManager> hashMap = this._connectionManagerPool;
        synchronized (hashMap) {
            final ZkConnectionManager zkConnectionManager = this.getOrCreateZkConnectionNamanger(connectionConfig, clientConfig.getConnectInitTimeout());
            if (zkConnectionManager == null) {
                throw new HelixException("Failed to create a connection manager in the pool to share.");
            }
            LOG.info("Sharing ZkConnection {} to a new SharedZkClient.", (Object)connectionConfig.toString());
            return new SharedZkClient(zkConnectionManager, clientConfig, new SharedZkClient.OnCloseCallback(){

                @Override
                public void onClose() {
                    SharedZkClientFactory.this.cleanupConnectionManager(zkConnectionManager);
                }
            });
        }
    }

    private ZkConnectionManager getOrCreateZkConnectionNamanger(HelixZkClient.ZkConnectionConfig connectionConfig, long connectInitTimeout) {
        ZkConnectionManager connectionManager = this._connectionManagerPool.get(connectionConfig);
        if (connectionManager == null || connectionManager.isClosed()) {
            connectionManager = new ZkConnectionManager(this.createZkConnection(connectionConfig), connectInitTimeout, connectionConfig.toString());
            this._connectionManagerPool.put(connectionConfig, connectionManager);
        }
        return connectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupConnectionManager(ZkConnectionManager zkConnectionManager) {
        HashMap<HelixZkClient.ZkConnectionConfig, ZkConnectionManager> hashMap = this._connectionManagerPool;
        synchronized (hashMap) {
            zkConnectionManager.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getActiveConnectionCount() {
        int count = 0;
        HashMap<HelixZkClient.ZkConnectionConfig, ZkConnectionManager> hashMap = this._connectionManagerPool;
        synchronized (hashMap) {
            for (ZkConnectionManager manager : this._connectionManagerPool.values()) {
                if (manager.isClosed()) continue;
                ++count;
            }
        }
        return count;
    }

    private static class SingletonHelper {
        private static final SharedZkClientFactory INSTANCE = new SharedZkClientFactory();

        private SingletonHelper() {
        }
    }
}

