/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.rest.server;

import java.util.HashMap;
import java.util.Map;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.InstanceType;
import org.apache.helix.manager.zk.ZKHelixAdmin;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.manager.zk.client.HelixZkClient;
import org.apache.helix.manager.zk.client.SharedZkClientFactory;
import org.apache.helix.task.TaskDriver;
import org.apache.helix.tools.ClusterSetup;

public class ServerContext {
    private final String _zkAddr;
    private HelixZkClient _zkClient;
    private ZKHelixAdmin _zkHelixAdmin;
    private ClusterSetup _clusterSetup;
    private ConfigAccessor _configAccessor;
    private final Map<String, HelixDataAccessor> _helixDataAccessorPool;
    private final Map<String, TaskDriver> _taskDriverPool;

    public ServerContext(String zkAddr) {
        this._zkAddr = zkAddr;
        this._helixDataAccessorPool = new HashMap<String, HelixDataAccessor>();
        this._taskDriverPool = new HashMap<String, TaskDriver>();
    }

    public HelixZkClient getHelixZkClient() {
        if (this._zkClient == null) {
            HelixZkClient.ZkClientConfig clientConfig = new HelixZkClient.ZkClientConfig();
            clientConfig.setZkSerializer((ZkSerializer)new ZNRecordSerializer());
            this._zkClient = SharedZkClientFactory.getInstance().buildZkClient(new HelixZkClient.ZkConnectionConfig(this._zkAddr), clientConfig);
        }
        return this._zkClient;
    }

    @Deprecated
    public ZkClient getZkClient() {
        return (ZkClient)this.getHelixZkClient();
    }

    public HelixAdmin getHelixAdmin() {
        if (this._zkHelixAdmin == null) {
            this._zkHelixAdmin = new ZKHelixAdmin(this.getHelixZkClient());
        }
        return this._zkHelixAdmin;
    }

    public ClusterSetup getClusterSetup() {
        if (this._clusterSetup == null) {
            this._clusterSetup = new ClusterSetup(this.getHelixZkClient(), this.getHelixAdmin());
        }
        return this._clusterSetup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskDriver getTaskDriver(String clusterName) {
        Map<String, TaskDriver> map = this._taskDriverPool;
        synchronized (map) {
            if (!this._taskDriverPool.containsKey(clusterName)) {
                this._taskDriverPool.put(clusterName, new TaskDriver(this.getHelixZkClient(), clusterName));
            }
            return this._taskDriverPool.get(clusterName);
        }
    }

    public ConfigAccessor getConfigAccessor() {
        if (this._configAccessor == null) {
            this._configAccessor = new ConfigAccessor(this.getHelixZkClient());
        }
        return this._configAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HelixDataAccessor getDataAccssor(String clusterName) {
        Map<String, HelixDataAccessor> map = this._helixDataAccessorPool;
        synchronized (map) {
            if (!this._helixDataAccessorPool.containsKey(clusterName)) {
                ZkBaseDataAccessor baseDataAccessor = new ZkBaseDataAccessor(this.getHelixZkClient());
                this._helixDataAccessorPool.put(clusterName, (HelixDataAccessor)new ZKHelixDataAccessor(clusterName, InstanceType.ADMINISTRATOR, (BaseDataAccessor)baseDataAccessor));
            }
            return this._helixDataAccessorPool.get(clusterName);
        }
    }

    public void close() {
        if (this._zkClient != null) {
            this._zkClient.close();
        }
    }
}

