/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.routing;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.zookeeper.constant.RoutingDataReaderType;
import org.apache.helix.zookeeper.exception.MultiZkException;
import org.apache.helix.zookeeper.routing.HttpRoutingDataReader;
import org.apache.helix.zookeeper.routing.RoutingDataReader;
import org.apache.helix.zookeeper.routing.ZkRoutingDataReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpZkFallbackRoutingDataReader
implements RoutingDataReader {
    private static final Logger LOG = LoggerFactory.getLogger(HttpZkFallbackRoutingDataReader.class);

    @Override
    public Map<String, List<String>> getRawRoutingData(String endpoint) {
        Map<RoutingDataReaderType, String> endpointMap = this.parseEndpoint(endpoint);
        try {
            return new HttpRoutingDataReader().getRawRoutingData(endpointMap.get((Object)RoutingDataReaderType.HTTP));
        }
        catch (MultiZkException e) {
            LOG.warn("HttpZkFallbackRoutingDataReader::getRawRoutingData: failed to read routing data via HTTP. Falling back to ZK!", (Throwable)e);
            return new ZkRoutingDataReader().getRawRoutingData(endpointMap.get((Object)RoutingDataReaderType.ZK));
        }
    }

    private Map<RoutingDataReaderType, String> parseEndpoint(String endpointString) {
        String[] endpoints = endpointString.split(",");
        if (endpoints.length != 2) {
            throw new MultiZkException("HttpZkFallbackRoutingDataReader::parseEndpoint: endpoint string does not contain two proper comma-separated endpoints for HTTP and ZK! Endpoint string: " + endpointString);
        }
        return ImmutableMap.of((Object)((Object)RoutingDataReaderType.HTTP), (Object)endpoints[0], (Object)((Object)RoutingDataReaderType.ZK), (Object)endpoints[1]);
    }
}

