/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.routing;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.datamodel.serializer.ZNRecordSerializer;
import org.apache.helix.zookeeper.exception.MultiZkException;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.apache.helix.zookeeper.routing.RoutingDataReader;
import org.apache.helix.zookeeper.zkclient.exception.ZkNoNodeException;

public class ZkRoutingDataReader
implements RoutingDataReader {
    @Override
    public Map<String, List<String>> getRawRoutingData(String endpoint) {
        List<String> allRealmAddresses;
        ZkClient zkClient = new ZkClient.Builder().setZkServer(endpoint).setZkSerializer(new ZNRecordSerializer()).build();
        HashMap<String, List<String>> routingData = new HashMap<String, List<String>>();
        try {
            allRealmAddresses = zkClient.getChildren("/METADATA_STORE_ROUTING_DATA");
        }
        catch (ZkNoNodeException e) {
            throw new MultiZkException("Routing data directory ZNode /METADATA_STORE_ROUTING_DATA does not exist. Routing ZooKeeper address: " + endpoint);
        }
        if (allRealmAddresses != null) {
            for (String realmAddress : allRealmAddresses) {
                ZNRecord record = (ZNRecord)zkClient.readData("/METADATA_STORE_ROUTING_DATA/" + realmAddress, true);
                if (record == null) continue;
                List<String> shardingKeys = record.getListField("ZK_PATH_SHARDING_KEYS");
                routingData.put(realmAddress, shardingKeys != null ? shardingKeys : Collections.emptyList());
            }
        }
        zkClient.close();
        return routingData;
    }
}

