/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.common;

import org.apache.helix.common.DedupEventBlockingQueue;
import org.apache.helix.zookeeper.zkclient.exception.ZkInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DedupEventProcessor<T, E>
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(DedupEventProcessor.class);
    protected final DedupEventBlockingQueue<T, E> _eventQueue;
    protected final String _clusterName;
    protected final String _processorName;

    public DedupEventProcessor(String processorName) {
        this(new String(), processorName);
    }

    public DedupEventProcessor(String clusterName, String processorName) {
        super(processorName + "-" + clusterName);
        this._processorName = processorName;
        this._eventQueue = new DedupEventBlockingQueue();
        this._clusterName = clusterName;
    }

    public DedupEventProcessor() {
        this(new String(), "Default-DedupEventProcessor");
    }

    @Override
    public void run() {
        logger.info("START " + this._processorName + " thread for cluster " + this._clusterName);
        while (!this.isInterrupted()) {
            try {
                E event = this._eventQueue.take();
                this.handleEvent(event);
            }
            catch (InterruptedException e) {
                logger.warn(this._processorName + " thread interrupted", (Throwable)e);
                this.interrupt();
            }
            catch (ZkInterruptedException e) {
                logger.warn(this._processorName + " thread caught a ZK connection interrupt", (Throwable)e);
                this.interrupt();
            }
            catch (ThreadDeath death) {
                throw death;
            }
            catch (Throwable t) {
                logger.error(this._processorName + " thread failed while running " + this._processorName, t);
            }
        }
        logger.info("END " + this._processorName + " thread for cluster " + this._clusterName);
    }

    protected abstract void handleEvent(E var1);

    public void queueEvent(T eventType, E event) {
        if (this.isInterrupted()) {
            return;
        }
        this._eventQueue.put(eventType, event);
    }

    public void resetEventQueue() {
        this._eventQueue.clear();
    }

    public void shutdown() {
        this.interrupt();
        this._eventQueue.clear();
    }
}

