/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.converter;

import java.io.IOException;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.engine.application.StatusInfo;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.engine.util.StringUtils;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.Resource;

public class StatusInfoHtmlConverter
extends ConverterHelper {
    private static final VariantInfo VARIANT_APPLICATION_XHTML = new VariantInfo(MediaType.APPLICATION_XHTML);
    private static final VariantInfo VARIANT_TEXT_HTML = new VariantInfo(MediaType.TEXT_HTML);

    @Override
    public List<Class<?>> getObjectClasses(Variant source) {
        List<Class<?>> result = null;
        if (this.isCompatible(source)) {
            result = this.addObjectClass(result, StatusInfo.class);
        }
        return result;
    }

    protected String getStatusLabel(StatusInfo status) {
        return status.getReasonPhrase() != null ? status.getReasonPhrase() : "No information available for this result status";
    }

    @Override
    public List<VariantInfo> getVariants(Class<?> source) throws IOException {
        List<VariantInfo> result = null;
        if (source != null && StatusInfo.class.isAssignableFrom(source)) {
            result = this.addVariant(result, VARIANT_TEXT_HTML);
            result = this.addVariant(result, VARIANT_APPLICATION_XHTML);
        }
        return result;
    }

    protected boolean isCompatible(Variant variant) {
        return variant != null && (VARIANT_TEXT_HTML.isCompatible(variant) || VARIANT_APPLICATION_XHTML.isCompatible(variant));
    }

    @Override
    public float score(Object source, Variant target, Resource resource) {
        float result = -1.0f;
        if (source instanceof StatusInfo && this.isCompatible(target)) {
            result = 1.0f;
        }
        return result;
    }

    @Override
    public <T> float score(Representation source, Class<T> target, Resource resource) {
        return -1.0f;
    }

    protected Representation toHtml(StatusInfo status) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>\n");
        sb.append("<head>\n");
        sb.append("   <title>Status page</title>\n");
        sb.append("</head>\n");
        sb.append("<body style=\"font-family: sans-serif;\">\n");
        sb.append("<p style=\"font-size: 1.2em;font-weight: bold;margin: 1em 0px;\">");
        sb.append(StringUtils.htmlEscape(this.getStatusLabel(status)));
        sb.append("</p>\n");
        if (status.getDescription() != null) {
            sb.append("<p>");
            sb.append(StringUtils.htmlEscape(status.getDescription()));
            sb.append("</p>\n");
        }
        sb.append("<p>You can get technical details <a href=\"");
        sb.append(status.getUri());
        sb.append("\">here</a>.<br>\n");
        if (status.getContactEmail() != null) {
            sb.append("For further assistance, you can contact the <a href=\"mailto:");
            sb.append(status.getContactEmail());
            sb.append("\">administrator</a>.<br>\n");
        }
        if (status.getHomeRef() != null) {
            sb.append("Please continue your visit at our <a href=\"");
            sb.append(status.getHomeRef());
            sb.append("\">home page</a>.\n");
        }
        sb.append("</p>\n");
        sb.append("</body>\n");
        sb.append("</html>\n");
        return new StringRepresentation((CharSequence)sb.toString(), MediaType.TEXT_HTML);
    }

    @Override
    public <T> T toObject(Representation source, Class<T> target, Resource resource) throws IOException {
        return null;
    }

    @Override
    public Representation toRepresentation(Object source, Variant target, Resource resource) throws IOException {
        Representation result = null;
        if (source != null && StatusInfo.class.isAssignableFrom(source.getClass())) {
            StatusInfo si = (StatusInfo)source;
            result = this.toHtml(si);
        }
        return result;
    }
}

