/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.agent;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.helix.ExternalCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemUtil {
    public static final String OS_NAME = System.getProperty("os.name");
    private static Logger LOG = LoggerFactory.getLogger(SystemUtil.class);

    public static ProcessStateCode getProcessState(String processId) throws Exception {
        if (OS_NAME.equals("Mac OS X") || OS_NAME.equals("Linux")) {
            ExternalCommand cmd = ExternalCommand.start((String[])new String[]{"ps", processId});
            cmd.waitFor();
            String[] lines = cmd.getStringOutput().split("[\\r\\n]+");
            if (lines.length != 2) {
                LOG.info("process: " + processId + " not exist");
                return null;
            }
            String[] attributes = lines[0].trim().split("\\s+");
            String[] values = lines[1].trim().split("\\s+");
            Character processStateCodeChar = null;
            for (int i = 0; i < attributes.length; ++i) {
                String attribute = attributes[i];
                if (!"STAT".equals(attribute) && !"S".equals(attribute)) continue;
                processStateCodeChar = Character.valueOf(values[i].charAt(0));
                break;
            }
            return ProcessStateCode.valueOf(Character.toString(processStateCodeChar.charValue()));
        }
        throw new UnsupportedOperationException("Not supported OS: " + OS_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPidFromFile(File file) {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(file));
            String string = line = br.readLine();
            return string;
        }
        catch (IOException e) {
            LOG.warn("fail to read pid from pidFile: " + file + ". will not monitor");
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LOG.error("fail to close file: " + file, (Throwable)e);
                }
            }
        }
        return null;
    }

    public static enum ProcessStateCode {
        D("Uninterruptible sleep (usually IO)"),
        R("Running or runnable (on run queue)"),
        S("Interruptible sleep (waiting for an event to complete)"),
        T("Stopped, either by a job control signal or because it is being traced."),
        W("paging (not valid since the 2.6.xx kernel)"),
        X("dead (should never be seen)"),
        Z("Defunct (\"zombie\") process, terminated but not reaped by its parent.");

        private final String _description;

        private ProcessStateCode(String description) {
            this._description = description;
        }

        public String getDescription() {
            return this._description;
        }
    }
}

