/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.cloud.event;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.cloud.event.AbstractEventHandler;
import org.apache.helix.util.HelixUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventHandlerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CloudEventHandlerFactory.class);
    private static Map<String, AbstractEventHandler> INSTANCE_MAP = new HashMap<String, AbstractEventHandler>();

    private CloudEventHandlerFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractEventHandler getInstance(String eventHandlerClassName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<CloudEventHandlerFactory> clazz = CloudEventHandlerFactory.class;
        synchronized (CloudEventHandlerFactory.class) {
            AbstractEventHandler instance = INSTANCE_MAP.get(eventHandlerClassName);
            if (instance == null) {
                LOG.info("Initiating an object of {}", (Object)eventHandlerClassName);
                instance = (AbstractEventHandler)HelixUtil.loadClass(AbstractEventHandler.class, eventHandlerClassName).newInstance();
                INSTANCE_MAP.put(eventHandlerClassName, instance);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }
}

