/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.constraints;

import java.util.Set;
import org.apache.helix.controller.rebalancer.waged.constraints.HardConstraint;
import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.controller.rebalancer.waged.model.ClusterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SamePartitionOnInstanceConstraint
extends HardConstraint {
    private static final Logger LOG = LoggerFactory.getLogger(SamePartitionOnInstanceConstraint.class);

    SamePartitionOnInstanceConstraint() {
    }

    @Override
    boolean isAssignmentValid(AssignableNode node, AssignableReplica replica, ClusterContext clusterContext) {
        Set<String> assignedPartitionsByResource = node.getAssignedPartitionsByResource(replica.getResourceName());
        if (assignedPartitionsByResource.contains(replica.getPartitionName())) {
            if (this.enableLogging) {
                LOG.info("Same partition ({}) of different states cannot co-exist in one instance", (Object)replica.getPartitionName());
            }
            return false;
        }
        return true;
    }

    @Override
    String getDescription() {
        return "Same partition of different states cannot co-exist in one instance";
    }
}

