/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.helix.AccessOption;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyType;
import org.apache.helix.api.status.ClusterManagementMode;
import org.apache.helix.controller.dataproviders.ManagementControllerDataProvider;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.BestPossibleStateOutput;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.ClusterStatus;
import org.apache.helix.model.ControllerHistory;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.PauseSignal;
import org.apache.helix.util.HelixUtil;
import org.apache.helix.util.RebalanceUtil;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementModeStage
extends AbstractBaseStage {
    private static final Logger LOG = LoggerFactory.getLogger(ManagementModeStage.class);
    private static final Set<String> PENDING_MESSAGE_TYPES = ImmutableSet.of((Object)Message.MessageType.PARTICIPANT_STATUS_CHANGE.name(), (Object)Message.MessageType.STATE_TRANSITION.name(), (Object)Message.MessageType.STATE_TRANSITION_CANCELLATION.name());

    @Override
    public void process(ClusterEvent event) throws Exception {
        this._eventId = event.getEventId();
        HelixManager manager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
        if (manager == null) {
            throw new StageException("HelixManager attribute value is null");
        }
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        ManagementControllerDataProvider cache = (ManagementControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        CurrentStateOutput currentStateOutput = (CurrentStateOutput)event.getAttribute(AttributeName.CURRENT_STATE.name());
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES_TO_REBALANCE.name());
        BestPossibleStateOutput bestPossibleStateOutput = RebalanceUtil.buildBestPossibleState(resourceMap.keySet(), currentStateOutput);
        event.addAttribute(AttributeName.BEST_POSSIBLE_STATE.name(), bestPossibleStateOutput);
        ClusterManagementMode managementMode = this.checkClusterFreezeStatus(cache.getEnabledLiveInstances(), cache.getLiveInstances(), cache.getAllInstancesMessages(), cache.getPauseSignal());
        this.recordClusterStatus(managementMode, cache.getPauseSignal(), manager.getInstanceName(), accessor);
        event.addAttribute(AttributeName.CLUSTER_STATUS.name(), managementMode);
    }

    private ClusterManagementMode checkClusterFreezeStatus(Set<String> enabledLiveInstances, Map<String, LiveInstance> liveInstanceMap, Map<String, Collection<Message>> allInstanceMessages, PauseSignal pauseSignal) {
        ClusterManagementMode.Type type;
        ClusterManagementMode.Status status = ClusterManagementMode.Status.COMPLETED;
        if (pauseSignal == null) {
            type = ClusterManagementMode.Type.NORMAL;
            if (HelixUtil.inManagementMode(pauseSignal, liveInstanceMap, enabledLiveInstances, allInstanceMessages)) {
                status = ClusterManagementMode.Status.IN_PROGRESS;
            }
        } else if (pauseSignal.isClusterPause()) {
            type = ClusterManagementMode.Type.CLUSTER_FREEZE;
            if (!this.instancesFullyFrozen(enabledLiveInstances, liveInstanceMap, allInstanceMessages)) {
                status = ClusterManagementMode.Status.IN_PROGRESS;
            }
        } else {
            type = ClusterManagementMode.Type.CONTROLLER_PAUSE;
        }
        return new ClusterManagementMode(type, status);
    }

    private boolean instancesFullyFrozen(Set<String> enabledLiveInstances, Map<String, LiveInstance> liveInstanceMap, Map<String, Collection<Message>> allInstanceMessages) {
        return enabledLiveInstances.stream().noneMatch(instance -> !LiveInstance.LiveInstanceStatus.FROZEN.equals((Object)((LiveInstance)liveInstanceMap.get(instance)).getStatus()) || this.hasPendingMessage((Collection)allInstanceMessages.get(instance)));
    }

    private boolean hasPendingMessage(Collection<Message> messages) {
        return messages != null && messages.stream().anyMatch(message -> PENDING_MESSAGE_TYPES.contains(message.getMsgType()));
    }

    private void recordClusterStatus(ClusterManagementMode mode, PauseSignal pauseSignal, String controllerName, HelixDataAccessor accessor) {
        PropertyKey statusPropertyKey = accessor.keyBuilder().clusterStatus();
        ClusterStatus clusterStatus = (ClusterStatus)accessor.getProperty(statusPropertyKey);
        if (clusterStatus == null) {
            clusterStatus = new ClusterStatus();
        }
        if (mode.getMode().equals((Object)clusterStatus.getManagementMode()) && mode.getStatus().equals((Object)clusterStatus.getManagementModeStatus())) {
            LOG.debug("Skip recording duplicate status mode={}, status={}", (Object)mode.getMode(), (Object)mode.getStatus());
            return;
        }
        clusterStatus.setManagementMode(mode.getMode());
        clusterStatus.setManagementModeStatus(mode.getStatus());
        if (!accessor.updateProperty(statusPropertyKey, clusterStatus)) {
            LOG.error("Failed to update cluster status {}", (Object)clusterStatus);
        }
        this.recordManagementModeHistory(mode, pauseSignal, controllerName, accessor);
    }

    private void recordManagementModeHistory(ClusterManagementMode mode, PauseSignal pauseSignal, String controllerName, HelixDataAccessor accessor) {
        String reason;
        if (!ClusterManagementMode.Status.COMPLETED.equals((Object)mode.getStatus())) {
            return;
        }
        String path = accessor.keyBuilder().controllerLeaderHistory().getPath();
        long timestamp = Instant.now().toEpochMilli();
        String fromHost = pauseSignal == null ? null : pauseSignal.getFromHost();
        String string = reason = pauseSignal == null ? null : pauseSignal.getReason();
        if (!accessor.getBaseDataAccessor().update(path, oldRecord -> {
            if (oldRecord == null) {
                oldRecord = new ZNRecord(PropertyType.HISTORY.toString());
            }
            return new ControllerHistory((ZNRecord)oldRecord).updateManagementModeHistory(controllerName, mode, fromHost, timestamp, reason);
        }, AccessOption.PERSISTENT)) {
            LOG.error("Failed to write management mode history to ZK!");
        }
    }
}

