/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.api.config.StateTransitionThrottleConfig;
import org.apache.helix.model.ClusterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StateTransitionThrottleController {
    private static final Logger logger = LoggerFactory.getLogger(StateTransitionThrottleController.class);
    Map<StateTransitionThrottleConfig.RebalanceType, Long> _pendingTransitionAllowedInCluster = new HashMap<StateTransitionThrottleConfig.RebalanceType, Long>();
    Map<String, Map<StateTransitionThrottleConfig.RebalanceType, Long>> _pendingTransitionAllowedPerInstance = new HashMap<String, Map<StateTransitionThrottleConfig.RebalanceType, Long>>();
    Map<String, Map<StateTransitionThrottleConfig.RebalanceType, Long>> _pendingTransitionAllowedPerResource = new HashMap<String, Map<StateTransitionThrottleConfig.RebalanceType, Long>>();
    private boolean _throttleEnabled = false;

    StateTransitionThrottleController(Set<String> resources, ClusterConfig clusterConfig, Set<String> liveInstances) {
        if (clusterConfig == null) {
            logger.warn("Cluster config is not found, no throttle config set!");
            return;
        }
        List<StateTransitionThrottleConfig> throttleConfigs = clusterConfig.getStateTransitionThrottleConfigs();
        if (throttleConfigs == null || throttleConfigs.isEmpty()) {
            logger.info("No throttle config is set!");
            return;
        }
        for (StateTransitionThrottleConfig config : throttleConfigs) {
            switch (config.getThrottleScope()) {
                case CLUSTER: {
                    this._pendingTransitionAllowedInCluster.put(config.getRebalanceType(), config.getMaxPartitionInTransition());
                    this._throttleEnabled = true;
                    break;
                }
                case RESOURCE: {
                    for (String resource : resources) {
                        this._pendingTransitionAllowedPerResource.computeIfAbsent(resource, k -> new HashMap()).put(config.getRebalanceType(), config.getMaxPartitionInTransition());
                    }
                    this._throttleEnabled = true;
                    break;
                }
                case INSTANCE: {
                    for (String instance : liveInstances) {
                        this._pendingTransitionAllowedPerInstance.computeIfAbsent(instance, k -> new HashMap()).put(config.getRebalanceType(), config.getMaxPartitionInTransition());
                    }
                    this._throttleEnabled = true;
                }
            }
        }
    }

    protected boolean isThrottleEnabled() {
        return this._throttleEnabled;
    }

    protected boolean shouldThrottleForCluster(StateTransitionThrottleConfig.RebalanceType rebalanceType) {
        if (this.shouldThrottleForANYType(this._pendingTransitionAllowedInCluster)) {
            return true;
        }
        Long clusterThrottle = this._pendingTransitionAllowedInCluster.get((Object)rebalanceType);
        return clusterThrottle != null && clusterThrottle <= 0L;
    }

    protected boolean shouldThrottleForResource(StateTransitionThrottleConfig.RebalanceType rebalanceType, String resourceName) {
        return this.shouldThrottleForGivenMap(rebalanceType, resourceName, this._pendingTransitionAllowedPerResource);
    }

    protected boolean shouldThrottleForInstance(StateTransitionThrottleConfig.RebalanceType rebalanceType, String instanceName) {
        return this.shouldThrottleForGivenMap(rebalanceType, instanceName, this._pendingTransitionAllowedPerInstance);
    }

    private boolean shouldThrottleForGivenMap(StateTransitionThrottleConfig.RebalanceType rebalanceType, String entryName, Map<String, Map<StateTransitionThrottleConfig.RebalanceType, Long>> transitionAllowedPerEntry) {
        if (this.shouldThrottleForCluster(rebalanceType)) {
            return true;
        }
        if (transitionAllowedPerEntry.containsKey(entryName)) {
            Map<StateTransitionThrottleConfig.RebalanceType, Long> throttleConfigMap = transitionAllowedPerEntry.get(entryName);
            Long instanceThrottle = throttleConfigMap.get((Object)rebalanceType);
            return instanceThrottle != null && instanceThrottle <= 0L || this.shouldThrottleForANYType(throttleConfigMap);
        }
        return false;
    }

    protected void chargeCluster(StateTransitionThrottleConfig.RebalanceType rebalanceType) {
        this.charge(rebalanceType, this._pendingTransitionAllowedInCluster);
    }

    protected void chargeResource(StateTransitionThrottleConfig.RebalanceType rebalanceType, String resource) {
        this.charge(rebalanceType, this._pendingTransitionAllowedPerResource.getOrDefault(resource, new HashMap()));
    }

    protected void chargeInstance(StateTransitionThrottleConfig.RebalanceType rebalanceType, String instance) {
        this.charge(rebalanceType, this._pendingTransitionAllowedPerInstance.getOrDefault(instance, new HashMap()));
    }

    private void charge(StateTransitionThrottleConfig.RebalanceType rebalanceType, Map<StateTransitionThrottleConfig.RebalanceType, Long> quota) {
        if (StateTransitionThrottleConfig.RebalanceType.NONE.equals((Object)rebalanceType)) {
            logger.error("Wrong rebalance type NONE as parameter");
            return;
        }
        quota.computeIfPresent(StateTransitionThrottleConfig.RebalanceType.ANY, (type, quotaNumber) -> Math.max(0L, quotaNumber - 1L));
        if (!rebalanceType.equals((Object)StateTransitionThrottleConfig.RebalanceType.ANY)) {
            quota.computeIfPresent(rebalanceType, (type, quotaNumber) -> Math.max(0L, quotaNumber - 1L));
        }
    }

    private boolean shouldThrottleForANYType(Map<StateTransitionThrottleConfig.RebalanceType, Long> pendingTransitionAllowed) {
        if (pendingTransitionAllowed.containsKey((Object)StateTransitionThrottleConfig.RebalanceType.ANY)) {
            Long anyTypeThrottle = pendingTransitionAllowed.get((Object)StateTransitionThrottleConfig.RebalanceType.ANY);
            return anyTypeThrottle != null && anyTypeThrottle <= 0L;
        }
        return false;
    }
}

