/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.time.Instant;
import org.apache.helix.HelixProperty;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public class PauseSignal
extends HelixProperty {
    private static final String DEFAULT_PAUSE_ID = "pause";

    public PauseSignal() {
        this(DEFAULT_PAUSE_ID);
    }

    public PauseSignal(String id) {
        super(id);
    }

    public PauseSignal(ZNRecord record) {
        super(record);
    }

    public void setReason(String reason) {
        this._record.setSimpleField(PauseSignalProperty.REASON.name(), reason);
    }

    public String getReason() {
        return this._record.getSimpleField(PauseSignalProperty.REASON.name());
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public void setClusterPause(boolean pause) {
        this._record.setBooleanField(PauseSignalProperty.CLUSTER_FREEZE.name(), pause);
    }

    public boolean isClusterPause() {
        return this._record.getBooleanField(PauseSignalProperty.CLUSTER_FREEZE.name(), false);
    }

    public void setFromHost(String host) {
        this._record.setSimpleField(PauseSignalProperty.FROM_HOST.name(), host);
    }

    public String getFromHost() {
        return this._record.getSimpleField(PauseSignalProperty.FROM_HOST.name());
    }

    public void setCancelPendingST(boolean cancel) {
        this._record.setBooleanField(PauseSignalProperty.CANCEL_PENDING_ST.name(), cancel);
    }

    public boolean getCancelPendingST() {
        return this._record.getBooleanField(PauseSignalProperty.CANCEL_PENDING_ST.name(), false);
    }

    public void setTriggerTime(long time) {
        this._record.setSimpleField(PauseSignalProperty.TRIGGER_TIME.name(), Instant.ofEpochMilli(time).toString());
    }

    public static enum PauseSignalProperty {
        REASON,
        CLUSTER_FREEZE,
        FROM_HOST,
        CANCEL_PENDING_ST,
        TRIGGER_TIME;

    }
}

