/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.helix.PropertyType;
import org.apache.helix.monitoring.mbeans.MonitorDomainNames;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.DynamicMBeanProvider;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.HistogramDynamicMetric;
import org.apache.helix.monitoring.mbeans.dynamicMBeans.SimpleDynamicMetric;

public class RoutingTableProviderMonitor
extends DynamicMBeanProvider {
    public static final String DATA_TYPE_KEY = "DataType";
    public static final String CLUSTER_KEY = "Cluster";
    public static final String DEFAULT = "DEFAULT";
    private static final String MBEAN_DESCRIPTION = "Helix RoutingTableProvider Monitor";
    private final String _sensorName;
    private final PropertyType _propertyType;
    private final String _clusterName;
    private SimpleDynamicMetric<Long> _callbackCounter;
    private SimpleDynamicMetric<Long> _eventQueueSizeGauge;
    private SimpleDynamicMetric<Long> _dataRefreshCounter;
    private HistogramDynamicMetric _dataRefreshLatencyGauge;
    private HistogramDynamicMetric _statePropLatencyGauge;

    public RoutingTableProviderMonitor(PropertyType propertyType, String clusterName) {
        this._propertyType = propertyType;
        this._clusterName = clusterName == null ? DEFAULT : clusterName;
        this._sensorName = String.format("%s.%s.%s", MonitorDomainNames.RoutingTableProvider.name(), this._clusterName, this._propertyType.name());
        this._dataRefreshLatencyGauge = new HistogramDynamicMetric("DataRefreshLatencyGauge", new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(this.getResetIntervalInMs().longValue(), TimeUnit.MILLISECONDS)));
        this._callbackCounter = new SimpleDynamicMetric<Long>("CallbackCounter", 0L);
        this._eventQueueSizeGauge = new SimpleDynamicMetric<Long>("EventQueueSizeGauge", 0L);
        this._dataRefreshCounter = new SimpleDynamicMetric<Long>("DataRefreshCounter", 0L);
        if (propertyType.equals((Object)PropertyType.CURRENTSTATES)) {
            this._statePropLatencyGauge = new HistogramDynamicMetric("StatePropagationLatencyGauge", new Histogram((Reservoir)new SlidingTimeWindowArrayReservoir(this.getResetIntervalInMs().longValue(), TimeUnit.MILLISECONDS)));
        }
    }

    @Override
    public String getSensorName() {
        return this._sensorName;
    }

    private ObjectName getMBeanName() throws MalformedObjectNameException {
        return new ObjectName(String.format("%s:%s=%s,%s=%s", MonitorDomainNames.RoutingTableProvider.name(), CLUSTER_KEY, this._clusterName, DATA_TYPE_KEY, this._propertyType.name()));
    }

    public void increaseCallbackCounters(long currentQueueSize) {
        this._callbackCounter.updateValue(this._callbackCounter.getValue() + 1L);
        this._eventQueueSizeGauge.updateValue(currentQueueSize);
    }

    public void increaseDataRefreshCounters(long startTime) {
        this._dataRefreshCounter.updateValue(this._dataRefreshCounter.getValue() + 1L);
        this._dataRefreshLatencyGauge.updateValue(System.currentTimeMillis() - startTime);
    }

    public void recordStatePropagationLatency(long latency) {
        if (this._statePropLatencyGauge != null) {
            this._statePropLatencyGauge.updateValue(latency);
        }
    }

    @Override
    public RoutingTableProviderMonitor register() throws JMException {
        ArrayList attributeList = new ArrayList();
        attributeList.add(this._dataRefreshLatencyGauge);
        attributeList.add(this._callbackCounter);
        attributeList.add(this._eventQueueSizeGauge);
        attributeList.add(this._dataRefreshCounter);
        if (this._statePropLatencyGauge != null) {
            attributeList.add(this._statePropLatencyGauge);
        }
        this.doRegister(attributeList, MBEAN_DESCRIPTION, this.getMBeanName());
        return this;
    }
}

