/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.replacement;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.pagememory.FullPageId;
import org.apache.ignite.internal.pagememory.persistence.GroupPartitionId;
import org.apache.ignite.internal.pagememory.persistence.PersistentPageMemory;
import org.apache.ignite.internal.pagememory.persistence.WriteDirtyPage;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointPages;
import org.apache.ignite.internal.pagememory.persistence.replacement.DelayedPageReplacementTracker;
import org.apache.ignite.internal.util.GridUnsafe;
import org.jetbrains.annotations.Nullable;

public class DelayedDirtyPageWrite {
    private final WriteDirtyPage flushDirtyPage;
    private final int pageSize;
    private final ThreadLocal<ByteBuffer> byteBufThreadLoc;
    private final DelayedPageReplacementTracker tracker;
    @Nullable
    private FullPageId fullPageId;
    @Nullable
    private PersistentPageMemory pageMemory;
    @Nullable
    private CheckpointPages checkpointPages;

    DelayedDirtyPageWrite(WriteDirtyPage flushDirtyPage, ThreadLocal<ByteBuffer> byteBufThreadLoc, int pageSize, DelayedPageReplacementTracker tracker) {
        this.flushDirtyPage = flushDirtyPage;
        this.pageSize = pageSize;
        this.byteBufThreadLoc = byteBufThreadLoc;
        this.tracker = tracker;
    }

    public void copyPageToTemporaryBuffer(PersistentPageMemory pageMemory, FullPageId pageId, ByteBuffer originPageBuf, CheckpointPages checkpointPages) {
        this.tracker.lock(pageId);
        ByteBuffer threadLocalBuf = this.byteBufThreadLoc.get();
        threadLocalBuf.rewind();
        long dstBufAddr = GridUnsafe.bufferAddress((ByteBuffer)threadLocalBuf);
        long srcBufAddr = GridUnsafe.bufferAddress((ByteBuffer)originPageBuf);
        GridUnsafe.copyMemory((long)srcBufAddr, (long)dstBufAddr, (long)this.pageSize);
        this.fullPageId = pageId;
        this.pageMemory = pageMemory;
        this.checkpointPages = checkpointPages;
    }

    public void flushCopiedPageIfExists() throws IgniteInternalCheckedException {
        if (this.fullPageId == null) {
            return;
        }
        assert (this.pageMemory != null) : this.fullPageId;
        assert (this.checkpointPages != null) : this.fullPageId;
        Throwable errorOnWrite = null;
        this.checkpointPages.blockPartitionDestruction(GroupPartitionId.convert(this.fullPageId));
        try {
            this.flushDirtyPage.write(this.pageMemory, this.fullPageId, this.byteBufThreadLoc.get());
        }
        catch (Throwable t) {
            errorOnWrite = t;
            throw t;
        }
        finally {
            this.checkpointPages.unblockPartitionDestruction(GroupPartitionId.convert(this.fullPageId));
            this.checkpointPages.unblockFsyncOnPageReplacement(this.fullPageId, errorOnWrite);
            this.tracker.unlock(this.fullPageId);
            this.fullPageId = null;
            this.pageMemory = null;
            this.checkpointPages = null;
        }
    }
}

