/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.converters;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.http.multipart.CompletedFileUpload;
import io.micronaut.http.multipart.CompletedPart;
import io.micronaut.http.server.netty.multipart.NettyCompletedAttribute;
import io.micronaut.http.server.netty.multipart.NettyCompletedFileUpload;
import io.micronaut.http.server.netty.multipart.NettyPartData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;

@Internal
public final class NettyConvertersSpi
implements TypeConverterRegistrar {
    public void register(ConversionService<?> conversionService) {
        conversionService.addConverter(ByteBuf.class, CharSequence.class, this.byteBufCharSequenceTypeConverter());
        conversionService.addConverter(CompositeByteBuf.class, CharSequence.class, this.compositeByteBufCharSequenceTypeConverter());
        conversionService.addConverter(ByteBuf.class, byte[].class, this.byteBufToArrayTypeConverter());
        conversionService.addConverter(byte[].class, ByteBuf.class, this.byteArrayToByteBuffTypeConverter());
        conversionService.addConverter(FileUpload.class, CompletedFileUpload.class, this.fileUploadToCompletedFileUploadConverter());
        conversionService.addConverter(Attribute.class, CompletedPart.class, this.attributeToCompletedPartConverter());
        conversionService.addConverter(NettyPartData.class, byte[].class, this.nettyPartDataToByteArrayConverter());
        conversionService.addConverter(Map.class, WriteBufferWaterMark.class, (map, targetType, context) -> {
            Object h = map.get("high");
            Object l = map.get("low");
            if (h != null && l != null) {
                try {
                    int high = Integer.parseInt(h.toString());
                    int low = Integer.parseInt(l.toString());
                    return Optional.of(new WriteBufferWaterMark(low, high));
                }
                catch (NumberFormatException e) {
                    context.reject((Exception)e);
                    return Optional.empty();
                }
            }
            return Optional.empty();
        });
        conversionService.addConverter(HttpData.class, byte[].class, this.httpDataToByteArrayConverter());
        conversionService.addConverter(HttpData.class, CharSequence.class, this.httpDataToStringConverter());
    }

    private TypeConverter<NettyPartData, byte[]> nettyPartDataToByteArrayConverter() {
        return (upload, targetType, context) -> {
            try {
                return Optional.of(upload.getBytes());
            }
            catch (IOException e) {
                context.reject((Exception)e);
                return Optional.empty();
            }
        };
    }

    private TypeConverter<FileUpload, CompletedFileUpload> fileUploadToCompletedFileUploadConverter() {
        return (object, targetType, context) -> {
            try {
                if (!object.isCompleted()) {
                    return Optional.empty();
                }
                return Optional.of(new NettyCompletedFileUpload((FileUpload)object));
            }
            catch (Exception e) {
                context.reject(e);
                return Optional.empty();
            }
        };
    }

    private TypeConverter<Attribute, CompletedPart> attributeToCompletedPartConverter() {
        return (object, targetType, context) -> {
            try {
                if (!object.isCompleted()) {
                    return Optional.empty();
                }
                return Optional.of(new NettyCompletedAttribute((Attribute)object));
            }
            catch (Exception e) {
                context.reject(e);
                return Optional.empty();
            }
        };
    }

    private TypeConverter<ByteBuf, CharSequence> byteBufCharSequenceTypeConverter() {
        return (object, targetType, context) -> Optional.of(object.toString(context.getCharset()));
    }

    private TypeConverter<CompositeByteBuf, CharSequence> compositeByteBufCharSequenceTypeConverter() {
        return (object, targetType, context) -> Optional.of(object.toString(context.getCharset()));
    }

    private TypeConverter<ByteBuf, byte[]> byteBufToArrayTypeConverter() {
        return (object, targetType, context) -> Optional.of(ByteBufUtil.getBytes((ByteBuf)object));
    }

    private TypeConverter<byte[], ByteBuf> byteArrayToByteBuffTypeConverter() {
        return (object, targetType, context) -> Optional.of(Unpooled.wrappedBuffer((byte[])object));
    }

    private TypeConverter<HttpData, CharSequence> httpDataToStringConverter() {
        return (upload, targetType, context) -> {
            try {
                if (!upload.isCompleted()) {
                    return Optional.empty();
                }
                ByteBuf byteBuf = upload.getByteBuf();
                return Optional.of(byteBuf.toString(context.getCharset()));
            }
            catch (Exception e) {
                context.reject(e);
                return Optional.empty();
            }
        };
    }

    private TypeConverter<HttpData, byte[]> httpDataToByteArrayConverter() {
        return (upload, targetType, context) -> {
            try {
                if (!upload.isCompleted()) {
                    return Optional.empty();
                }
                ByteBuf byteBuf = upload.getByteBuf();
                return Optional.of(ByteBufUtil.getBytes((ByteBuf)byteBuf));
            }
            catch (Exception e) {
                context.reject(e);
                return Optional.empty();
            }
        };
    }
}

