/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.util.Locale;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeTransforms;

public class SqlJsonRemoveFunction
extends SqlFunction {
    public SqlJsonRemoveFunction() {
        super("JSON_REMOVE", SqlKind.OTHER_FUNCTION, ReturnTypes.VARCHAR_2000.andThen(SqlTypeTransforms.FORCE_NULLABLE), null, null, SqlFunctionCategory.SYSTEM);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.from(2);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        int operandCount = callBinding.getOperandCount();
        assert (operandCount >= 2);
        if (!OperandTypes.ANY.checkSingleOperandType(callBinding, callBinding.operand(0), 0, throwOnFailure)) {
            return false;
        }
        SqlTypeFamily[] families = new SqlTypeFamily[operandCount];
        families[0] = SqlTypeFamily.ANY;
        for (int i = 1; i < operandCount; ++i) {
            families[i] = SqlTypeFamily.CHARACTER;
        }
        return OperandTypes.family(families).checkOperandTypes(callBinding, throwOnFailure);
    }

    @Override
    public String getAllowedSignatures(String opNameToUse) {
        return String.format(Locale.ROOT, "'%s(<%s>, <%s>, <%s>...)'", this.getName(), SqlTypeFamily.ANY, SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER);
    }
}

